/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.swing.LinedBoxPanel;
import com.skcraft.launcher.swing.MessageLog;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.PastebinPoster;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import lombok.NonNull;

public class ConsoleFrame
extends JFrame {
    private static ConsoleFrame globalFrame;
    private final Image trayRunningIcon;
    private final Image trayClosedIcon;
    private final MessageLog messageLog;
    private LinedBoxPanel buttonsPanel;
    private boolean registeredGlobalLog = false;

    public ConsoleFrame(int numLines, boolean colorEnabled) {
        this(SharedLocale.tr("console.title"), numLines, colorEnabled);
    }

    public ConsoleFrame(@NonNull String title, int numLines, boolean colorEnabled) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.messageLog = new MessageLog(numLines, colorEnabled);
        this.trayRunningIcon = SwingHelper.createImage(Launcher.class, "tray_ok.png");
        this.trayClosedIcon = SwingHelper.createImage(Launcher.class, "tray_closed.png");
        this.setTitle(title);
        this.setIconImage(this.trayRunningIcon);
        this.setSize(new Dimension(650, 400));
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ConsoleFrame.this.performClose();
            }
        });
    }

    private void initComponents() {
        JButton pastebinButton = new JButton(SharedLocale.tr("console.uploadLog"));
        JButton clearLogButton = new JButton(SharedLocale.tr("console.clearLog"));
        this.buttonsPanel = new LinedBoxPanel(true);
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.buttonsPanel.addElement(pastebinButton);
        this.buttonsPanel.addElement(clearLogButton);
        this.add((Component)this.buttonsPanel, "North");
        this.add((Component)this.messageLog, "Center");
        clearLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleFrame.this.messageLog.clear();
            }
        });
        pastebinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleFrame.this.pastebinLog();
            }
        });
    }

    private void registerLoggerHandler() {
        if (!this.registeredGlobalLog) {
            this.getMessageLog().registerLoggerHandler();
            this.registeredGlobalLog = true;
        }
    }

    protected void performClose() {
        this.messageLog.detachGlobalHandler();
        this.messageLog.clear();
        this.registeredGlobalLog = false;
        this.dispose();
    }

    private void pastebinLog() {
        String text = this.messageLog.getPastableText();
        this.messageLog.log(SharedLocale.tr("console.pasteUploading", text.length()), this.messageLog.asHighlighted());
        PastebinPoster.paste(text, new PastebinPoster.PasteCallback(){

            @Override
            public void handleSuccess(String url) {
                ConsoleFrame.this.messageLog.log(SharedLocale.tr("console.pasteUploaded", url), ConsoleFrame.this.messageLog.asHighlighted());
                SwingHelper.openURL(url, (Component)ConsoleFrame.this.messageLog);
            }

            @Override
            public void handleError(String err) {
                ConsoleFrame.this.messageLog.log(SharedLocale.tr("console.pasteFailed", err), ConsoleFrame.this.messageLog.asError());
            }
        });
    }

    public static void showMessages() {
        ConsoleFrame frame = globalFrame;
        if (frame == null) {
            globalFrame = frame = new ConsoleFrame(10000, false);
            frame.setTitle(SharedLocale.tr("console.launcherConsoleTitle"));
            frame.registerLoggerHandler();
            frame.setVisible(true);
        } else {
            frame.setVisible(true);
            frame.registerLoggerHandler();
            frame.requestFocus();
        }
    }

    public static void hideMessages() {
        ConsoleFrame frame = globalFrame;
        if (frame != null) {
            frame.setVisible(false);
        }
    }

    public Image getTrayRunningIcon() {
        return this.trayRunningIcon;
    }

    public Image getTrayClosedIcon() {
        return this.trayClosedIcon;
    }

    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    public LinedBoxPanel getButtonsPanel() {
        return this.buttonsPanel;
    }
}

