/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class FileMover
implements InstallTask {
    private static final Logger log = Logger.getLogger(FileMover.class.getName());
    private final File from;
    private final File to;

    public FileMover(@NonNull File from, @NonNull File to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public void execute(Launcher launcher) throws IOException {
        log.log(Level.INFO, "Moving to {0} (from {1})...", new Object[]{this.to.getAbsoluteFile(), this.from.getName()});
        this.to.getParentFile().mkdirs();
        this.to.delete();
        this.from.renameTo(this.to);
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("installer.movingFile", this.from, this.to);
    }
}

