/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class InstallLog {
    @JsonIgnore
    private File baseDir;
    private Map<String, Set<String>> entries = new HashMap<String, Set<String>>();
    @JsonIgnore
    private Set<String> cache = new HashSet<String>();

    public synchronized void add(@NonNull String group, @NonNull String entry) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.cache.add(entry);
        Set<String> subEntries = this.entries.get(group);
        if (subEntries == null) {
            subEntries = new HashSet<String>();
            this.entries.put(group, subEntries);
        }
        subEntries.add(entry);
    }

    public synchronized void add(@NonNull File group, @NonNull File entry) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.add(this.relativize(group), this.relativize(entry));
    }

    public synchronized boolean has(@NonNull String entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.cache.contains(entry);
    }

    public synchronized boolean has(@NonNull File entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.has(this.relativize(entry));
    }

    public synchronized boolean copyGroupFrom(InstallLog other, String group) {
        Set<String> otherSet = other.entries.get(group);
        if (otherSet == null) {
            return false;
        }
        for (String entry : otherSet) {
            this.add(group, entry);
        }
        return true;
    }

    public synchronized boolean copyGroupFrom(@NonNull InstallLog other, @NonNull File entry) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.copyGroupFrom(other, this.relativize(entry));
    }

    @JsonIgnore
    public synchronized Set<Map.Entry<String, Set<String>>> getEntrySet() {
        return this.entries.entrySet();
    }

    public synchronized boolean hasGroup(String group) {
        return this.entries.containsKey(group);
    }

    private String relativize(File child) {
        Preconditions.checkNotNull(this.baseDir);
        URI uri = child.toURI();
        String relative = this.baseDir.toURI().relativize(uri).getPath();
        if (relative.equals(uri.toString())) {
            throw new IllegalArgumentException("Child path not in base");
        }
        return relative;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Map<String, Set<String>> getEntries() {
        return this.entries;
    }

    public Set<String> getCache() {
        return this.cache;
    }

    @JsonIgnore
    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setEntries(Map<String, Set<String>> entries) {
        this.entries = entries;
    }

    @JsonIgnore
    public void setCache(Set<String> cache) {
        this.cache = cache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstallLog)) {
            return false;
        }
        InstallLog other = (InstallLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$baseDir = this.getBaseDir();
        File other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
            return false;
        }
        Map<String, Set<String>> this$entries = this.getEntries();
        Map<String, Set<String>> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        Set<String> this$cache = this.getCache();
        Set<String> other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstallLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
        Map<String, Set<String>> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        Set<String> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    public String toString() {
        return "InstallLog(baseDir=" + this.getBaseDir() + ", entries=" + this.getEntries() + ", cache=" + this.getCache() + ")";
    }
}

