/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.skcraft.launcher.model.minecraft.FeatureList;
import com.skcraft.launcher.model.minecraft.Rule;
import com.skcraft.launcher.model.minecraft.mapper.ArgumentValueDeserializer;
import com.skcraft.launcher.model.minecraft.mapper.ArgumentValueSerializer;
import com.skcraft.launcher.util.Environment;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GameArgument {
    @JsonProperty(value="value")
    @JsonDeserialize(using=ArgumentValueDeserializer.class)
    @JsonSerialize(using=ArgumentValueSerializer.class)
    private List<String> values;
    private List<Rule> rules;

    public GameArgument(List<String> values) {
        this.values = values;
    }

    public GameArgument(String value) {
        this.values = Lists.newArrayList(value);
    }

    @JsonIgnore
    public String getJoinedValue() {
        return Joiner.on(' ').join(this.values);
    }

    public boolean shouldApply(Environment environment, FeatureList featureList) {
        if (this.getRules() == null) {
            return true;
        }
        boolean result = false;
        for (Rule rule : this.rules) {
            if (!rule.matches(environment, featureList)) continue;
            result = rule.isAllowed();
        }
        return result;
    }

    public List<String> getValues() {
        return this.values;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="value")
    @JsonDeserialize(using=ArgumentValueDeserializer.class)
    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameArgument)) {
            return false;
        }
        GameArgument other = (GameArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GameArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "GameArgument(values=" + this.getValues() + ", rules=" + this.getRules() + ")";
    }

    public GameArgument() {
    }
}

