/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;

public class MavenName {
    @JsonValue
    private final String fullName;
    private final String group;
    private final String path;
    private final String version;
    private final String classifier;
    private final String extension;
    private final String filePath;

    public String toString() {
        return this.fullName;
    }

    @JsonCreator
    public static MavenName from(String mavenName) {
        if (mavenName == null) {
            return null;
        }
        List<String> split = Splitter.on(':').splitToList(mavenName);
        int size = split.size();
        String group = split.get(0);
        String name = split.get(1);
        String version = split.get(2);
        String classifier = null;
        String extension = "jar";
        String fileName = name + "-" + version;
        if (size > 3) {
            classifier = split.get(3);
            if (classifier.indexOf("@") != -1) {
                List<String> parts = Splitter.on('@').splitToList(classifier);
                classifier = parts.get(0);
                extension = parts.get(1);
            }
            fileName = fileName + "-" + classifier;
        }
        fileName = fileName + "." + extension;
        String filePath = Joiner.on('/').join(group.replace('.', '/'), name, version, fileName);
        return new MavenName(mavenName, group, name, version, classifier, extension, filePath);
    }

    public MavenName(String fullName, String group, String path, String version, String classifier, String extension, String filePath) {
        this.fullName = fullName;
        this.group = group;
        this.path = path;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.filePath = filePath;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenName)) {
            return false;
        }
        MavenName other = (MavenName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        return !(this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        return result;
    }
}

