/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceInternalFrameUI
extends BasicInternalFrameUI {
    private SubstanceInternalFrameTitlePane titlePane;
    protected PropertyChangeListener substancePropertyListener;

    public SubstanceInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceInternalFrameUI((JInternalFrame)comp);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new SubstanceInternalFrameTitlePane(w);
        return this.titlePane;
    }

    @Override
    protected void installComponents() {
        if (SubstanceCoreUtilities.isRoundedCorners(this.frame)) {
            this.frame.setOpaque(false);
        }
        super.installComponents();
    }

    @Override
    protected void uninstallComponents() {
        this.titlePane.uninstall();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("closed".equals(propertyName)) {
                    SubstanceInternalFrameUI.this.titlePane.uninstall();
                    JInternalFrame.JDesktopIcon jdi = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    SubstanceDesktopIconUI ui = (SubstanceDesktopIconUI)jdi.getUI();
                    ui.uninstallIfNecessary(jdi);
                } else if ("background".equals(propertyName)) {
                    Color newBackgr = (Color)evt.getNewValue();
                    if (!(newBackgr instanceof UIResource)) {
                        SubstanceInternalFrameUI.this.getTitlePane().setBackground(newBackgr);
                        SubstanceInternalFrameUI.this.frame.getDesktopIcon().setBackground(newBackgr);
                    }
                } else if ("ancestor".equals(propertyName)) {
                    JInternalFrame.JDesktopIcon jdi = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    SubstanceDesktopIconUI ui = (SubstanceDesktopIconUI)jdi.getUI();
                    ui.installIfNecessary(jdi);
                } else if ("selected".equals(propertyName)) {
                    SubstanceInternalFrameUI.this.titlePane.setActive((Boolean)evt.getNewValue());
                } else if (("windowRoundedCorners".equals(propertyName) || "maximum".equals(propertyName)) && SubstanceCoreUtilities.isRoundedCorners(SubstanceInternalFrameUI.this.frame)) {
                    SubstanceInternalFrameUI.this.frame.setOpaque(false);
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners();
    }

    public SubstanceInternalFrameTitlePane getTitlePane() {
        return this.titlePane;
    }

    void setWindowModified(boolean isWindowModified) {
        this.titlePane.getCloseButton().putClientProperty("windowModified", isWindowModified);
        SubstanceDesktopIconUI desktopIconUi = (SubstanceDesktopIconUI)this.frame.getDesktopIcon().getUI();
        desktopIconUi.setWindowModified(isWindowModified);
    }
}

