/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.dialog;

import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OfflineUsernameDialog
extends JDialog {
    private final JTextField usernameField = new JTextField(20);
    private final JButton okButton = new JButton(SharedLocale.tr("button.ok"));
    private final JButton cancelButton = new JButton(SharedLocale.tr("button.cancel"));
    private String enteredUsername = null;

    public OfflineUsernameDialog(Window parent) {
        super(parent, SharedLocale.tr("login.offline.title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel messageLabel = new JLabel(SharedLocale.tr("login.offline.message"));
        messageLabel.setAlignmentX(0.0f);
        mainPanel.add(messageLabel);
        mainPanel.add(Box.createVerticalStrut(10));
        JPanel usernamePanel = new JPanel(new BorderLayout(5, 0));
        JLabel usernameLabel = new JLabel(SharedLocale.tr("login.offline.username"));
        usernamePanel.add((Component)usernameLabel, "West");
        usernamePanel.add((Component)this.usernameField, "Center");
        usernamePanel.setAlignmentX(0.0f);
        mainPanel.add(usernamePanel);
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.okButton);
        this.add((Component)buttonPanel, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineUsernameDialog.this.attemptOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineUsernameDialog.this.dispose();
            }
        });
        this.usernameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineUsernameDialog.this.attemptOk();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OfflineUsernameDialog.this.usernameField.requestFocusInWindow();
            }
        });
    }

    private void attemptOk() {
        String username = this.usernameField.getText().trim();
        if (username.isEmpty()) {
            SwingHelper.showErrorDialog(this, SharedLocale.tr("login.offline.noUsernameError"), SharedLocale.tr("login.offline.noUsernameTitle"));
            return;
        }
        this.enteredUsername = username;
        this.dispose();
    }

    public static String showUsernameDialog(Window parent) {
        OfflineUsernameDialog dialog = new OfflineUsernameDialog(parent);
        dialog.setVisible(true);
        return dialog.enteredUsername;
    }
}

