/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch.runtime;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.PlatformRuntimeFinder;
import com.skcraft.launcher.util.Environment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LinuxRuntimeFinder
implements PlatformRuntimeFinder {
    @Override
    public Set<File> getLauncherDirectories(Environment env) {
        return ImmutableSet.of(new File(System.getenv("HOME"), ".minecraft"));
    }

    @Override
    public List<File> getCandidateJavaLocations() {
        File[] runtimesList;
        ArrayList<File> entries = Lists.newArrayList();
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            entries.add(new File(javaHome));
        }
        if ((runtimesList = new File("/usr/lib/jvm").listFiles()) != null) {
            Arrays.stream(runtimesList).map(file -> {
                try {
                    return file.getCanonicalFile();
                }
                catch (IOException exception) {
                    return file;
                }
            }).distinct().forEach(entries::add);
        }
        return entries;
    }

    @Override
    public List<JavaRuntime> getExtraRuntimes() {
        return Collections.emptyList();
    }
}

