/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import lombok.NonNull;

public class ObjectSwingMapper {
    private final List<FieldMapping> mappings = new ArrayList<FieldMapping>();
    private final Object object;

    public ObjectSwingMapper(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.object = object;
    }

    public void copyFromObject() {
        for (FieldMapping mapping : this.mappings) {
            mapping.copyFromObject();
        }
    }

    public void copyFromSwing() {
        for (FieldMapping mapping : this.mappings) {
            mapping.copyFromSwing();
        }
    }

    private void add(@NonNull FieldMapping mapping) {
        if (mapping == null) {
            throw new NullPointerException("mapping is marked non-null but is null");
        }
        this.mappings.add(mapping);
    }

    private <V> MutatorAccessorField<V> getField(@NonNull String field, Class<V> clazz) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return new MutatorAccessorField<V>(this.object, field, clazz);
    }

    public void map(final @NonNull JTextComponent textComponent, String name) {
        if (textComponent == null) {
            throw new NullPointerException("textComponent is marked non-null but is null");
        }
        final MutatorAccessorField<String> field = this.getField(name, String.class);
        this.add(new FieldMapping(){

            @Override
            public void copyFromObject() {
                textComponent.setText((String)field.get());
            }

            @Override
            public void copyFromSwing() {
                field.set(Strings.emptyToNull(textComponent.getText()));
            }
        });
    }

    public void map(final @NonNull JSpinner spinner, String name) {
        if (spinner == null) {
            throw new NullPointerException("spinner is marked non-null but is null");
        }
        final MutatorAccessorField<Integer> field = this.getField(name, Integer.TYPE);
        this.add(new FieldMapping(){

            @Override
            public void copyFromObject() {
                spinner.setValue(field.get());
            }

            @Override
            public void copyFromSwing() {
                field.set((Integer)spinner.getValue());
            }
        });
    }

    public void map(final @NonNull JCheckBox check, String name) {
        if (check == null) {
            throw new NullPointerException("check is marked non-null but is null");
        }
        final MutatorAccessorField<Boolean> field = this.getField(name, Boolean.TYPE);
        this.add(new FieldMapping(){

            @Override
            public void copyFromObject() {
                check.setSelected((Boolean)field.get());
            }

            @Override
            public void copyFromSwing() {
                field.set(check.isSelected());
            }
        });
    }

    public static class MutatorAccessorField<V> {
        private final Class<V> clazz;
        private final Object object;
        private final Method mutator;
        private final Method accessor;

        public MutatorAccessorField(Object object, String name, Class<V> clazz) {
            this.object = object;
            this.clazz = clazz;
            Method mutator = null;
            Method accessor = null;
            for (Method method : object.getClass().getMethods()) {
                if (this.isAccessor(method, name)) {
                    accessor = method;
                    continue;
                }
                if (!this.isMutator(method, name)) continue;
                mutator = method;
            }
            if (accessor == null) {
                throw new NoSuchMethodError("Failed to find accessor pair on " + object.getClass().getCanonicalName() + " for " + name);
            }
            if (mutator == null) {
                throw new NoSuchMethodError("Failed to find mutator pair on " + object.getClass().getCanonicalName() + " for " + name);
            }
            this.mutator = mutator;
            this.accessor = accessor;
        }

        private boolean isAccessor(Method method, String name) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            return (methodName.equalsIgnoreCase("get" + name) || methodName.equalsIgnoreCase("is" + name)) && paramTypes.length == 0 && this.clazz.isAssignableFrom(returnType);
        }

        private boolean isMutator(Method method, String name) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            return methodName.equalsIgnoreCase("set" + name) && paramTypes.length == 1 && paramTypes[0].isAssignableFrom(this.clazz);
        }

        public V get() {
            try {
                Object value = this.accessor.invoke(this.object, new Object[0]);
                return (V)value;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void set(V value) {
            try {
                this.mutator.invoke(this.object, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface FieldMapping {
        public void copyFromObject();

        public void copyFromSwing();
    }
}

