/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.swing.EmptyIcon;
import com.skcraft.launcher.swing.TextFieldPopupMenu;
import com.skcraft.launcher.util.Environment;
import com.skcraft.launcher.util.Platform;
import com.skcraft.launcher.util.SharedLocale;
import com.skcraft.launcher.util.SwingExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.JTextComponent;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public final class SwingHelper {
    private static final Logger log = Logger.getLogger(SwingHelper.class.getName());
    private static final ClipboardOwner clipboardOwner = new ClipboardOwner(){

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    private static final Joiner NEW_LINE_JOINER = Joiner.on("\n");

    private SwingHelper() {
    }

    public static String htmlEscape(String str) {
        return str.replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;");
    }

    public static String htmlWrap(String message) {
        return "<html><div style=\"width: 250px\">" + SwingHelper.htmlEscape(message);
    }

    public static void setClipboard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), clipboardOwner);
    }

    public static void browseDir(File file, Component component) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(component, SharedLocale.tr("errors.openDirError", file.getAbsolutePath()), SharedLocale.tr("errorTitle"), 0);
        }
    }

    public static void openURL(@NonNull String url, @NonNull Component parentComponent) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (parentComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        try {
            SwingHelper.openURL(new URL(url), parentComponent);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static void openURL(URL url, Component parentComponent) {
        try {
            SwingHelper.openURL(url.toURI());
        }
        catch (IOException e) {
            SwingHelper.showErrorDialog(parentComponent, SharedLocale.tr("errors.openUrlError", url.toString()), SharedLocale.tr("errorTitle"));
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "Malformed URL; this is a programming error!", e);
        }
    }

    public static void openURL(URI url) throws IOException {
        block2: {
            try {
                Desktop.getDesktop().browse(url);
            }
            catch (UnsupportedOperationException e) {
                if (Environment.detectPlatform() != Platform.LINUX) break block2;
                Runtime.getRuntime().exec(new String[]{"xdg-open", url.toString()});
            }
        }
    }

    public static void showErrorDialog(Component parentComponent, @NonNull String message, @NonNull String title) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        SwingHelper.showErrorDialog(parentComponent, message, title, null);
    }

    public static void showErrorDialog(Component parentComponent, @NonNull String message, @NonNull String title, Throwable throwable) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        String detailsText = null;
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            detailsText = sw.toString();
        }
        SwingHelper.showMessageDialog(parentComponent, message, title, detailsText, 0);
    }

    public static void showMessageDialog(final Component parentComponent, final @NonNull String message, final @NonNull String title, final String detailsText, final int messageType) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            String htmlMessage = SwingHelper.htmlWrap(message);
            JPanel panel = new JPanel(new BorderLayout(0, detailsText != null ? 20 : 0));
            panel.add((Component)new JLabel(htmlMessage), "North");
            if (detailsText != null) {
                JTextArea textArea = new JTextArea(SharedLocale.tr("errors.reportErrorPreface") + detailsText);
                JLabel tempLabel = new JLabel();
                textArea.setFont(tempLabel.getFont());
                textArea.setBackground(tempLabel.getBackground());
                textArea.setTabSize(2);
                textArea.setEditable(false);
                textArea.setComponentPopupMenu(TextFieldPopupMenu.INSTANCE);
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setPreferredSize(new Dimension(350, 120));
                panel.add((Component)scrollPane, "Center");
            }
            JOptionPane.showMessageDialog(parentComponent, panel, title, messageType);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingHelper.showMessageDialog(parentComponent, message, title, detailsText, messageType);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean confirmDialog(final Component parentComponent, final @NonNull String message, final @NonNull String title) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return JOptionPane.showConfirmDialog(parentComponent, message, title, 0) == 0;
        }
        final AtomicBoolean yesSelected = new AtomicBoolean();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    yesSelected.set(SwingHelper.confirmDialog(parentComponent, title, message));
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return yesSelected.get();
    }

    public static void equalWidth(Component ... component) {
        Dimension dim;
        double widest = 0.0;
        for (Component comp : component) {
            dim = comp.getPreferredSize();
            if (!(dim.getWidth() > widest)) continue;
            widest = dim.getWidth();
        }
        for (Component comp : component) {
            dim = comp.getPreferredSize();
            comp.setPreferredSize(new Dimension((int)widest, (int)dim.getHeight()));
        }
    }

    public static void removeOpaqueness(Component ... components) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        for (Component component : components) {
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.setOpaque(false);
            SwingHelper.removeOpaqueness(jComponent.getComponents());
        }
    }

    public static Image createImage(Class<?> clazz, String name) {
        URL resource = clazz.getResource(name);
        if (resource != null) {
            return Toolkit.getDefaultToolkit().createImage(resource);
        }
        log.log(Level.WARNING, "Failed to read image from resource: " + name);
        return null;
    }

    public static Icon createIcon(Class<?> clazz, String name) {
        Image image = SwingHelper.createImage(clazz, name);
        if (image != null) {
            return new ImageIcon(image);
        }
        return new EmptyIcon(16, 16);
    }

    public static Icon createIcon(Class<?> clazz, String name, int width, int height) {
        Image image = SwingHelper.createImage(clazz, name);
        if (image != null) {
            return new ImageIcon(image.getScaledInstance(width, height, 4));
        }
        return new EmptyIcon(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readBufferedImage(Class<?> clazz, String path) {
        InputStream in = null;
        try {
            in = clazz.getResourceAsStream(path);
            if (in != null) {
                BufferedImage bufferedImage = ImageIO.read(in);
                return bufferedImage;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return null;
    }

    public static void setFrameIcon(JFrame frame, Class<?> clazz, String path) {
        BufferedImage image = SwingHelper.readBufferedImage(clazz, path);
        if (image != null) {
            frame.setIconImage(image);
        }
    }

    public static void focusLater(final @NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                component.requestFocusInWindow();
            }
        });
    }

    public static void flattenJSplitPane(JSplitPane splitPane) {
        splitPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        BasicSplitPaneUI flatDividerSplitPaneUI = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border b) {
                    }
                };
            }
        };
        splitPane.setUI(flatDividerSplitPaneUI);
        splitPane.setBorder(null);
    }

    public static void addErrorDialogCallback(final Window owner, ListenableFuture<?> future) {
        Futures.addCallback(future, new FutureCallback<Object>(){

            @Override
            public void onSuccess(Object result) {
            }

            @Override
            public void onFailure(Throwable t) {
                String message;
                if (t instanceof InterruptedException || t instanceof CancellationException) {
                    return;
                }
                if (t instanceof LauncherException) {
                    message = t.getLocalizedMessage();
                    t = t.getCause();
                } else {
                    message = t.getLocalizedMessage();
                    if (message == null) {
                        message = SharedLocale.tr("errors.genericError");
                    }
                }
                log.log(Level.WARNING, "Task failed", t);
                SwingHelper.showErrorDialog(owner, message, SharedLocale.tr("errorTitle"), t);
            }
        }, SwingExecutor.INSTANCE);
    }

    public static Component alignTabbedPane(Component component) {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.add(component);
        container.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 10000), new Dimension(0, 10000)));
        SwingHelper.removeOpaqueness(container);
        return container;
    }

    public static void setTextAndResetCaret(JTextComponent component, String text) {
        component.setText(text);
        component.setCaretPosition(0);
    }

    public static JScrollPane wrapScrollPane(Component component) {
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setVerticalScrollBarPolicy(22);
        return scrollPane;
    }

    public static String listToLines(List<String> lines) {
        return NEW_LINE_JOINER.join(lines);
    }

    public static List<String> linesToList(String text) {
        String[] tokens = text.replace("\r", "\n").split("\n");
        ArrayList<String> values = Lists.newArrayList();
        for (String token : tokens) {
            String value = token.trim();
            if (value.isEmpty()) continue;
            values.add(value);
        }
        return values;
    }

    public static void addActionListeners(AbstractButton button, ActionListener[] listeners) {
        for (ActionListener listener : listeners) {
            button.addActionListener(listener);
        }
    }

    public static boolean setLookAndFeel(String lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to set look and feel to " + lookAndFeel, e);
            return false;
        }
    }

    public static void setSwingProperties(String appName) {
        UIManager.getDefaults().put("SplitPane.border", BorderFactory.createEmptyBorder());
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }
}

