/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import com.skcraft.launcher.util.LocaleEncodingControl;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class SharedLocale {
    private static final Logger log = Logger.getLogger(SharedLocale.class.getName());
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle bundle;

    public static Locale getLocale() {
        return locale;
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static String tr(String key) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                log.log(Level.WARNING, "Failed to find message", e);
            }
        }
        return "${" + key + "}";
    }

    public static String tr(String key, Object ... args) {
        if (bundle != null) {
            try {
                MessageFormat formatter = new MessageFormat(SharedLocale.tr(key));
                formatter.setLocale(SharedLocale.getLocale());
                return formatter.format(args);
            }
            catch (MissingResourceException e) {
                log.log(Level.WARNING, "Failed to find message", e);
            }
        }
        return "${" + key + "}:" + args;
    }

    public static boolean loadBundle(@NonNull String baseName, @NonNull Locale locale) {
        if (baseName == null) {
            throw new NullPointerException("baseName is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        try {
            SharedLocale.locale = locale;
            bundle = ResourceBundle.getBundle(baseName, locale, SharedLocale.class.getClassLoader(), new LocaleEncodingControl());
            return true;
        }
        catch (MissingResourceException e) {
            log.log(Level.SEVERE, "Failed to load resource bundle", e);
            return false;
        }
    }
}

