/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;

public class SubstancePopupMenuUI
extends BasicPopupMenuUI {
    protected ContainerListener substanceContainerListener;
    protected PopupMenuListener substancePopupMenuListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstancePopupMenuUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceContainerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                MenuUtilities.cleanPopupLayoutMetrics(SubstancePopupMenuUI.this.popupMenu);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                MenuUtilities.cleanPopupLayoutMetrics(SubstancePopupMenuUI.this.popupMenu);
            }
        };
        this.popupMenu.addContainerListener(this.substanceContainerListener);
        this.substancePopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                for (int i = 0; i < SubstancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem menuItem;
                    Component comp = SubstancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(comp instanceof JMenuItem) || !(menuItem = (JMenuItem)comp).isEnabled() || !menuItem.getModel().isArmed()) continue;
                    menuItem.getModel().setArmed(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                for (int i = 0; i < SubstancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem menuItem;
                    Component comp = SubstancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(comp instanceof JMenuItem) || !(menuItem = (JMenuItem)comp).isEnabled() || !menuItem.getModel().isArmed()) continue;
                    menuItem.getModel().setArmed(false);
                }
            }
        };
        this.popupMenu.addPopupMenuListener(this.substancePopupMenuListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenu.removeContainerListener(this.substanceContainerListener);
        this.substanceContainerListener = null;
        this.popupMenu.removePopupMenuListener(this.substancePopupMenuListener);
        this.substancePopupMenuListener = null;
        super.uninstallListeners();
    }
}

