/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.pigzombie;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeModContainer;

public class Entity_SpecialPigZombie
extends EntityPigZombie
implements ISpecialMob,
IRangedAttackMob {
    private static final int AI_PRIORITY_ATTACK = 2;
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialPigZombie.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/zombie_pigman.png")};
    private EntityAIBase currentAttackAI;
    private SpecialMobData specialData;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(5009705);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/pigzombie/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186384_ai);
    }

    public Entity_SpecialPigZombie(World world) {
        super(world);
        this.getSpecialData().setImmuneToFire(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
        SpecialMobData data = this.getSpecialData();
        data.rangedAttackDamage = 2.0f;
        data.rangedAttackSpread = 14.0f;
        data.rangedWalkSpeed = 0.8f;
        data.rangedAttackMaxCooldown = data.rangedAttackCooldown = 20;
        data.rangedAttackMaxRange = 15.0f;
        this.initTypeAI();
        this.setCombatTask();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialPigZombie>(this, SCALE);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        float prevMax = this.func_110138_aP();
        this.applyTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void applyTypeAttributes() {
    }

    protected void disableRangedAI() {
        this.setRangedAI(1.0, 20, 0.0f);
    }

    protected void setRangedAI(double walkSpeed, int cooldownTime) {
        this.setRangedAI(walkSpeed, cooldownTime, this.getSpecialData().rangedAttackMaxRange);
    }

    protected void setRangedAI(double walkSpeed, int cooldownTime, float range) {
        SpecialMobData data = this.getSpecialData();
        data.rangedWalkSpeed = (float)walkSpeed;
        data.rangedAttackCooldown = cooldownTime;
        data.rangedAttackMaxCooldown = cooldownTime;
        data.rangedAttackMaxRange = range;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.currentAttackAI);
            SpecialMobData data = this.getSpecialData();
            ItemStack weapon = this.func_184614_ca();
            this.currentAttackAI = data.rangedAttackMaxRange > 0.0f && !weapon.func_190926_b() && weapon.func_77973_b() instanceof ItemBow ? new EntityAIAttackRangedBow((EntityMob)this, (double)data.rangedWalkSpeed, data.rangedAttackCooldown, data.rangedAttackMaxRange) : new EntityAIZombieAttack((EntityZombie)this, 1.0, false);
            this.field_70714_bg.func_75776_a(2, this.currentAttackAI);
        }
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (this.field_70146_Z.nextFloat() < Config.get().ZOMBIE_PIGMEN.BOW_CHANCE) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        }
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow arrow = this.getArrow(distanceFactor);
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double dZ = target.field_70161_v - this.field_70161_v;
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        arrow.func_70186_c(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().rangedAttackSpread * (1.0f - 0.2858f * (float)this.field_70170_p.func_175659_aa().func_151525_a()));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected EntityArrow getArrow(float distanceFactor) {
        EntitySpectralArrow arrow;
        ItemStack quiverSlot = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (quiverSlot.func_77973_b() == Items.field_185166_h) {
            arrow = new EntitySpectralArrow(this.field_70170_p, (EntityLivingBase)this);
            arrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        } else {
            arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
            arrow.func_190547_a((EntityLivingBase)this, distanceFactor);
            if (quiverSlot.func_77973_b() == Items.field_185167_i) {
                ((EntityTippedArrow)arrow).func_184555_a(quiverSlot);
            }
        }
        arrow.func_70239_b(this.getSpecialData().getRangedDamage(distanceFactor));
        return arrow;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.func_180431_b(source) && amount > 0.0f && !source.func_76363_c()) {
            Vec3d hitPos;
            boolean hasShield;
            ItemStack shield = this.func_184614_ca();
            boolean bl = hasShield = !shield.func_190926_b() && shield.func_77973_b().isShield(shield, (EntityLivingBase)this);
            if (!hasShield) {
                shield = this.func_184592_cb();
                boolean bl2 = hasShield = !shield.func_190926_b() && shield.func_77973_b().isShield(shield, (EntityLivingBase)this);
            }
            if (hasShield && (source.func_76352_a() || this.field_70146_Z.nextFloat() < 0.33f) && (hitPos = source.func_188404_v()) != null) {
                Vec3d lookVec = this.func_70676_i(1.0f);
                Vec3d hitVec = hitPos.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
                hitVec = new Vec3d(hitVec.field_72450_a, 0.0, hitVec.field_72449_c);
                if (hitVec.func_72430_b(lookVec) < 0.0) {
                    Entity entity;
                    this.func_184590_k(amount);
                    if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                        this.func_190629_c((EntityLivingBase)entity);
                    }
                    this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    return false;
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return super.func_70047_e() * this.getSpecialData().getBaseScaleForPreScaledValues();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.setCombatTask();
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        if (data == null) {
            data = new NonnullGroupData();
        }
        data = super.func_180482_a(difficulty, data);
        this.func_82227_f(this.field_70146_Z.nextFloat() < ForgeModContainer.zombieBabyChance);
        if (this.func_70631_g_()) {
            if (this.field_70170_p.field_73012_v.nextFloat() < Config.get().ZOMBIE_PIGMEN.CHICKEN_JOCKEY_CHANCE) {
                List list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                if (!list.isEmpty()) {
                    EntityChicken entitychicken = (EntityChicken)list.get(0);
                    entitychicken.func_152117_i(true);
                    this.func_184220_m((Entity)entitychicken);
                }
            } else if (this.field_70170_p.field_73012_v.nextFloat() < Config.get().ZOMBIE_PIGMEN.CHICKEN_JOCKEY_FORCED_CHANCE) {
                EntityChicken chickenMount = new EntityChicken(this.field_70170_p);
                chickenMount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                chickenMount.func_180482_a(difficulty, null);
                chickenMount.func_152117_i(true);
                this.field_70170_p.func_72838_d((Entity)chickenMount);
                this.func_184220_m((Entity)chickenMount);
            }
        }
        return data;
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (!this.field_70170_p.field_72995_K && slot == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    private static class NonnullGroupData
    implements IEntityLivingData {
        private NonnullGroupData() {
        }
    }
}

