/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.block;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.manual.IBlockWithDocumentation;
import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OpenGlassesTerminalBlock
extends BlockContainer
implements IBlockWithDocumentation {
    public static OpenGlassesTerminalBlock DEFAULT_BLOCK;

    public OpenGlassesTerminalBlock() {
        super(Material.field_151573_f);
        this.func_149647_a(OpenGlasses.creativeTab);
        this.setRegistryName("openglassesterminal");
        this.func_149711_c(3.0f);
        this.func_149663_c("openglassesterminal");
    }

    @Override
    public String getDocumentationName(World world, BlockPos pos) {
        return "Terminal";
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "Terminal";
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new OpenGlassesTerminalTileEntity();
    }

    public static <T> T getTileEntity(IBlockAccess world, BlockPos pos, Class<T> T) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && T.isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item item;
        if (player.func_70093_af() || world.field_72995_K) {
            return false;
        }
        OpenGlassesTerminalTileEntity te = OpenGlassesTerminalBlock.getTileEntity((IBlockAccess)world, pos, OpenGlassesTerminalTileEntity.class);
        if (te == null) {
            return false;
        }
        ItemStack glassesStack = player.func_184614_ca();
        if (!glassesStack.func_190926_b() && (item = glassesStack.func_77973_b()) instanceof OpenGlassesItem) {
            OpenGlassesHostsNBT.link(glassesStack, te.getComponent().getUUID(), player);
            return true;
        }
        return false;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.onBlockPreDestroy(worldIn, pos);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.onBlockPreDestroy(worldIn, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.onBlockPreDestroy(worldIn, pos);
    }

    public void onBlockPreDestroy(World world, BlockPos pos) {
        OpenGlassesTerminalTileEntity te = OpenGlassesTerminalBlock.getTileEntity((IBlockAccess)world, pos, OpenGlassesTerminalTileEntity.class);
        if (te != null) {
            te.getComponent().remove();
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

