/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.asm;

import java.io.IOException;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import p455w0rdslib.asm.SafeClassWriter;

public class ClassTransformer
implements IClassTransformer {
    private static final String RENDERGLOBAL_CLASS = "net.minecraft.client.renderer.RenderGlobal";
    private static final String CHUNKRENDERCONTAINER_CLASS = "net.minecraft.client.renderer.ChunkRenderContainer";
    private static final String HOOKS_PATH = "p455w0rdslib/asm/Hooks";
    public static boolean enabled = true;
    private static boolean init = false;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && this.shouldPatch()) {
            if (transformedName.equals(RENDERGLOBAL_CLASS)) {
                return ClassTransformer.patchRenderGlobal(basicClass);
            }
            if (transformedName.equals(CHUNKRENDERCONTAINER_CLASS)) {
                return ClassTransformer.patchChunkRenderContainer(basicClass);
            }
        }
        return basicClass;
    }

    private boolean shouldPatch() {
        if (!init) {
            init = true;
            if (this.classExists("org.spongepowered.mod.SpongeCoremod") || this.classExists("org.dimdev.jeid.JEIDTransformer") || this.classExists("optifine.OptiFineForgeTweaker") || this.classExists("elucent.albedo.asm.ASMTransformer")) {
                enabled = false;
            }
        }
        return enabled;
    }

    private boolean classExists(String name) {
        try {
            return Launch.classLoader.getClassBytes(name) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static byte[] patchRenderGlobal(byte[] c) {
        ClassReader reader = new ClassReader(c);
        ClassNode node = new ClassNode();
        boolean found = false;
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (found) break;
            if (!method.name.equals("func_174982_a") && !method.name.equals("renderBlockLayer") || !method.desc.equals("(Lnet/minecraft/util/BlockRenderLayer;)V")) continue;
            InsnList instr = method.instructions;
            instr.insert(instr.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "enableColoredLighting", "()V", false));
            AbstractInsnNode[] nodeList = instr.toArray();
            for (int i = nodeList.length - 1; i >= 0; --i) {
                AbstractInsnNode currentNode = nodeList[i];
                if (currentNode.getOpcode() != 177) continue;
                instr.insertBefore(currentNode, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "disableColoredLighting", "()V", false));
                found = true;
                continue block0;
            }
        }
        SafeClassWriter writer = new SafeClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static byte[] patchChunkRenderContainer(byte[] c) {
        ClassReader reader = new ClassReader(c);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("func_178003_a") && !method.name.equals("preRenderChunk") || !method.desc.equals("(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V")) continue;
            InsnList instr = method.instructions;
            AbstractInsnNode[] nodeList = instr.toArray();
            for (int i = nodeList.length - 1; i >= 0; --i) {
                AbstractInsnNode currentNode = nodeList[i];
                if (currentNode.getOpcode() != 177) continue;
                instr.insertBefore(currentNode, (AbstractInsnNode)new VarInsnNode(25, 1));
                instr.insertBefore(currentNode, (AbstractInsnNode)new MethodInsnNode(184, HOOKS_PATH, "preRenderChunk", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", false));
            }
        }
        SafeClassWriter writer = new SafeClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

