/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.commons0815.utils;

import ben_mkiv.guitoolkit.common.guiWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExperienceUtils {
    private static final int[] xpmap = new int[21863];

    @SideOnly(value=Side.CLIENT)
    public static void drawExperienceBar(guiWindow gui, int y, int XP) {
        ExperienceUtils.drawExperienceBar(gui, gui.getXOffset(182), y, XP);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawExperienceBar(guiWindow gui, int x, int y, int XP) {
        int level = ExperienceUtils.getLevelFromExp(XP);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        gui.func_73729_b(x, y, 0, 64, 182, 5);
        int widthBarActive = (int)Math.round(182.0 * ((double)(XP - ExperienceUtils.getExpFromLevel(level)) / (double)ExperienceUtils.getXpBarCap(level)));
        gui.func_73729_b(x, y, 0, 69, widthBarActive, 5);
    }

    public static int getTierFromXP(int level) {
        if (level >= 40) {
            return 4;
        }
        if (level >= 30) {
            return 3;
        }
        if (level >= 20) {
            return 2;
        }
        if (level >= 10) {
            return 1;
        }
        return 0;
    }

    public static int getLevelFromExp(long experience) {
        for (int i = 1; i < xpmap.length; ++i) {
            if ((long)xpmap[i] <= experience) continue;
            return i;
        }
        return xpmap.length;
    }

    public static int getExpFromLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        return xpmap[level - 1];
    }

    public static int getXpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    static {
        int res = 0;
        for (int level = 0; level < xpmap.length; ++level) {
            if ((res += ExperienceUtils.getXpBarCap(level)) < 0) {
                res = Integer.MAX_VALUE;
            }
            ExperienceUtils.xpmap[level] = res;
        }
    }
}

