/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.ICustomShape;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class CustomShape
extends WidgetGLWorld
implements ICustomShape {
    public ArrayList<ArrayList> vectors = new ArrayList();
    public boolean gl_strips = false;
    public boolean smooth_shading = false;

    @Override
    public int getVertexCount() {
        return this.vectors.size();
    }

    @Override
    public void setVertex(int n, float nx, float ny, float nz) {
        if (this.getVertexCount() <= n) {
            this.vectors.get(n).set(0, Float.valueOf(nx));
            this.vectors.get(n).set(1, Float.valueOf(ny));
            this.vectors.get(n).set(2, Float.valueOf(nz));
        } else {
            this.addVertex(nx, ny, nz);
        }
    }

    @Override
    public void addVertex(float nx, float ny, float nz) {
        ArrayList<Float> vector = new ArrayList<Float>();
        vector.add(Float.valueOf(nx));
        vector.add(Float.valueOf(ny));
        vector.add(Float.valueOf(nz));
        this.vectors.add(vector);
    }

    @Override
    public void removeVertex(int n) {
        if (this.getVertexCount() <= n) {
            this.vectors.remove(n);
        }
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeBoolean(this.gl_strips);
        buff.writeInt(this.vectors.size());
        for (int i = 0; i < this.vectors.size(); ++i) {
            buff.writeFloat(((Float)this.vectors.get(i).get(0)).floatValue());
            buff.writeFloat(((Float)this.vectors.get(i).get(1)).floatValue());
            buff.writeFloat(((Float)this.vectors.get(i).get(2)).floatValue());
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.gl_strips = buff.readBoolean();
        this.vectors = new ArrayList();
        int vectorCount = buff.readInt();
        for (int i = 0; i < vectorCount; ++i) {
            this.addVertex(buff.readFloat(), buff.readFloat(), buff.readFloat());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableCustom();
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderableCustom
    extends WidgetGLOverlay.RenderableGLWidget {
        public RenderableCustom() {
            super(CustomShape.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (CustomShape.this.vectors.size() < 3) {
                return;
            }
            this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            if (CustomShape.this.smooth_shading) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            if (CustomShape.this.gl_strips) {
                GlStateManager.func_187447_r((int)5);
                for (int i = 0; i < CustomShape.this.vectors.size(); ++i) {
                    GlStateManager.func_187435_e((float)((Float)CustomShape.this.vectors.get(i).get(0)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i).get(1)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i).get(2)).floatValue());
                }
            } else {
                GL11.glBegin((int)4);
                for (int i = 3; i <= CustomShape.this.vectors.size(); i += 3) {
                    GlStateManager.func_187435_e((float)((Float)CustomShape.this.vectors.get(i - 3).get(0)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 3).get(1)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 3).get(2)).floatValue());
                    GlStateManager.func_187435_e((float)((Float)CustomShape.this.vectors.get(i - 2).get(0)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 2).get(1)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 2).get(2)).floatValue());
                    GlStateManager.func_187435_e((float)((Float)CustomShape.this.vectors.get(i - 1).get(0)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 1).get(1)).floatValue(), (float)((Float)CustomShape.this.vectors.get(i - 1).get(2)).floatValue());
                }
            }
            GlStateManager.func_187437_J();
            this.postRender();
        }
    }
}

