/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.network.messages;

import ben_mkiv.rendertoolkit.network.messages.ClientEventPacket;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientRequest
implements IMessage {
    protected double width;
    protected double height;
    protected double scale;
    protected EventType type;
    private UUID instanceUUID = null;

    public ClientRequest() {
    }

    public ClientRequest(EventType type, UUID instanceUUID, double width, double height, double scale) {
        this(type, instanceUUID);
        this.width = width;
        this.height = height;
        this.scale = scale;
    }

    public ClientRequest(EventType type, UUID instanceUUID) {
        this.type = type;
        this.instanceUUID = instanceUUID;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.instanceUUID = new UUID(buf.readLong(), buf.readLong());
        }
        this.type = EventType.values()[buf.readInt()];
        if (this.type.equals((Object)EventType.SET_RENDER_RESOLUTION)) {
            this.width = buf.readDouble();
            this.height = buf.readDouble();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.instanceUUID != null);
        if (this.instanceUUID != null) {
            buf.writeLong(this.instanceUUID.getMostSignificantBits());
            buf.writeLong(this.instanceUUID.getLeastSignificantBits());
        }
        buf.writeInt(this.type.ordinal());
        if (this.type.equals((Object)EventType.SET_RENDER_RESOLUTION)) {
            buf.writeDouble(this.width);
            buf.writeDouble(this.height);
        }
    }

    public static class Handler
    implements IMessageHandler<ClientRequest, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ClientRequest message, MessageContext ctx) {
            switch (message.type) {
                case SET_RENDER_RESOLUTION: {
                    ClientSurface.instances.setRenderResolution(new Vec3d(message.width, message.height, message.scale), message.instanceUUID);
                    break;
                }
                case ASYNC_SCREEN_SIZES: {
                    ClientSurface.instances.sendResolution(message.instanceUUID);
                    break;
                }
                case SYNC_SCREEN_SIZE: {
                    return new ClientEventPacket(ben_mkiv.rendertoolkit.network.EventType.GLASSES_SCREEN_SIZE, new Vec3d((double)ClientSurface.resolution.func_78326_a(), (double)ClientSurface.resolution.func_78328_b(), (double)ClientSurface.resolution.func_78325_e()));
                }
            }
            return null;
        }
    }

    public static enum EventType {
        SYNC_SCREEN_SIZE,
        ASYNC_SCREEN_SIZES,
        SET_RENDER_RESOLUTION;

    }
}

