### 2D Overlay Widget
## Text2D
```lua
widget = component.glasses.addText2D()
-- adds a Text to the 2D Overlay
```
```lua
widget.setText("My Text")
-- sets the text string

widget.getText():String
-- returns configured text
```

# Experimental TrueType support
methods here may change, specially from which location and how fonts get loaded, currently fonts installed on your pc are used.

```lua
require("component").glasses.getFonts()
-- shows a list of available fonts 
-- this runs serverside so it may include fonts that arent available on your client!

widget.setFont(String:fontName)
-- sets a font (empty string resets the font to vanilla minecraft font)

widget.setAntialias(Boolean:enabled)
-- enables/disables antialiasing for TrueType Fonts
-- (doesnt affect vanilla font rendering)

widget.setFontSize(Integer:fontSize)
-- sets the TrueTypeFont size
-- (doesnt affect vanilla font rendering)
```

### Examples
```lua
-- add a truetype text
glasses = require("component").glasses
widget = component.glasses.addText2D()
widget.setText("Hello World")
widget.setFont("verdana")
widget.setFontSize(24)
```

### methods
* [default](Widget_Methods_default)
  * [getID](Widget_Methods_default#getID)
  * [removeWidget](Widget_Methods_default#removeWidget)
* [private](Widget_Methods_private)
  * [getOwner](Widget_Methods_private#getOwner)
  * [getOwnerUUID](Widget_Methods_private#getOwnerUUID)
  * [setOwner](Widget_Methods_private#setOwner)
* [alignment](Widget_Methods_alignments)
  * [setVerticalAlign](Widget_Methods_alignments#setVerticalAlign)
  * [setHorizontalAlign](Widget_Methods_alignments#setHorizontalAlign)
* [visibility](Widget_Methods_visibility)
  * [isVisible](Widget_Methods_visibility#isVisible)
  * [setVisible](Widget_Methods_visibility#setVisible)
  
* [Modifier Methods](WidgetModifiers)
  * [addColor](WidgetModifiers#addColor)
  * [addRotation](WidgetModifiers#addRotation)
  * [addScale](WidgetModifiers#addScale)
  * [addTranslation](WidgetModifiers#addTranslation)
  * [getModifiers](WidgetModifierMethods#getModifiers)
  * [removeModifier](WidgetModifierMethods#removeModifier)
  * [setCondition](WidgetModifierConditions)
* [Modifier Animation](WidgetModifiers#animation)
  * [setEasing](WidgetModifiers#seteasing)
  * [removeEasing](WidgetModifiers#removeeasing)