/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.upgrades;

import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class UpgradeGeolyzer
extends UpgradeItem {
    @Override
    public ItemStack install(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74767_n("geolyzer") || tag.func_74762_e("radarRange") < 128) {
            tag.func_74757_a("geolyzer", true);
            tag.func_74768_a("radarRange", Math.min(tag.func_74762_e("radarRange") + 16, 128));
        }
        return stack;
    }

    public static int getRange(ItemStack stack) {
        return UpgradeGeolyzer.hasUpgrade(stack) ? stack.func_77978_p().func_74762_e("radarRange") : 0;
    }

    @Override
    public int getUpgradeExperienceCost() {
        return 20;
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    @Override
    public int getEnergyUsageCurrent(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("radarRange") / 16 * this.getEnergyUsage();
    }

    @Override
    public boolean isInstalled(ItemStack stack) {
        return UpgradeGeolyzer.hasUpgrade(stack);
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("opencomputers", "geolyzer"));
    }

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("geolyzer");
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (UpgradeGeolyzer.hasUpgrade(stack)) {
            tooltip.add("geolyzer: installed");
            tooltip.add("radar Range: " + stack.func_77978_p().func_74762_e("radarRange"));
        } else {
            tooltip.add("geolyzer: not installed");
            tooltip.add("\u00a78requires opencomputers geolyzer\u00a77");
        }
        return tooltip;
    }
}

