/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.entity;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pcl.opensecurity.common.blocks.BlockEnergyTurret;

public class EntityEnergyBolt
extends EntityThrowable {
    public static final String NAME = "energybolt";
    private int life = 100;
    private float damage = 0.0f;
    private static DamageSource energy = new DamageSource("energybolt").func_76349_b();
    private static HashSet<Material> passableMaterials = new HashSet();
    private static HashSet<Material> breakAbleMaterials = new HashSet();
    private static final DataParameter<Boolean> NOTICEMESENPAI = EntityDataManager.func_187226_a(EntityEnergyBolt.class, (DataSerializer)DataSerializers.field_187198_h);
    private FakePlayer fakePlayer;

    public EntityEnergyBolt(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_189654_d(true);
        this.func_184224_h(true);
        if (!world.field_72995_K) {
            this.fakePlayer = new FakePlayer(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(world.field_73011_w.getDimension()), new GameProfile(UUID.randomUUID(), NAME));
        }
    }

    public void setHeading(float yaw, float pitch) {
        this.field_70159_w = Math.sin(yaw) * Math.cos(pitch);
        this.field_70181_x = Math.sin(pitch);
        this.field_70179_y = Math.cos(yaw) * Math.cos(pitch);
    }

    public void setDamage(float damageIn) {
        this.damage = damageIn;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(NOTICEMESENPAI, (Object)true);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.damage = tag.func_74760_g("damage");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("damage", this.damage);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    private boolean canPassBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return passableMaterials.contains(state.func_185904_a()) || state.func_177230_c() instanceof BlockEnergyTurret;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (0 >= --this.life) {
            this.func_70106_y();
        }
    }

    boolean breakBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (world.field_72995_K) {
            return false;
        }
        if (!breakAbleMaterials.contains(state.func_185904_a())) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block.removedByPlayer(state, world, pos, (EntityPlayer)this.fakePlayer, true)) {
            TileEntity tile = world.func_175625_s(pos);
            block.func_176206_d(world, pos, state);
            block.func_180657_a(world, (EntityPlayer)this.fakePlayer, pos, state, tile, this.getDiamondHoe());
        }
        return true;
    }

    ItemStack setToolDefaultEnchants(ItemStack stack) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(Enchantments.field_185308_t, 1);
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
        return stack;
    }

    ItemStack getDiamondHoe() {
        return this.setToolDefaultEnchants(new ItemStack(Items.field_151012_L));
    }

    ItemStack getDiamondPick() {
        return this.setToolDefaultEnchants(new ItemStack(Items.field_151046_w));
    }

    ItemStack getDiamondSword() {
        return this.setToolDefaultEnchants(new ItemStack(Items.field_151048_u));
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        switch (result.field_72313_a) {
            case ENTITY: {
                result.field_72308_g.func_70097_a(energy, this.damage);
                this.func_70106_y();
                break;
            }
            case BLOCK: {
                if (this.breakBlock(this.func_130014_f_(), result.func_178782_a())) {
                    this.func_70106_y();
                }
                if (this.canPassBlock(this.func_130014_f_(), result.func_178782_a())) break;
                this.func_70106_y();
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    static {
        passableMaterials.add(Material.field_151579_a);
        passableMaterials.add(Material.field_151592_s);
        passableMaterials.add(Material.field_151581_o);
        passableMaterials.add(Material.field_151586_h);
        passableMaterials.add(Material.field_151587_i);
        breakAbleMaterials.add(Material.field_151585_k);
        breakAbleMaterials.add(Material.field_151584_j);
        breakAbleMaterials.add(Material.field_151582_l);
        breakAbleMaterials.add(Material.field_151569_G);
    }
}

