/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.protection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.protection.IProtection;
import pcl.opensecurity.common.protection.ProtectionAreaChunk;
import pcl.opensecurity.networking.PacketProtectionAdd;
import pcl.opensecurity.networking.PacketProtectionRemove;

public class Protection
extends WorldSavedData {
    private static final String DATA_NAME = "opensecurity_ProtectionData";
    HashMap<ChunkPos, ArrayList<ProtectionAreaChunk>> chunkAreas = new HashMap();
    static Protection clientInstance = new Protection();
    public int clientInstanceWorld = Integer.MAX_VALUE;

    public Protection() {
        super(DATA_NAME);
    }

    public Protection(String s) {
        super(s);
    }

    public static Protection get(World world) {
        if (!world.field_72995_K) {
            MapStorage storage = world.getPerWorldStorage();
            Protection instance = (Protection)storage.func_75742_a(Protection.class, DATA_NAME);
            if (instance == null) {
                instance = new Protection();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
        if (Protection.clientInstance.clientInstanceWorld != world.field_73011_w.getDimension()) {
            clientInstance = new Protection();
            Protection.clientInstance.clientInstanceWorld = world.field_73011_w.getDimension();
        }
        return clientInstance;
    }

    public static boolean addArea(World world, AxisAlignedBB area, BlockPos controller) {
        if (Protection.get(world).isProtectedArea(area)) {
            return false;
        }
        for (ChunkPos chunk : Protection.getChunks(area)) {
            AxisAlignedBB newArea = area.func_191500_a(new AxisAlignedBB((double)chunk.func_180334_c(), 0.0, (double)chunk.func_180333_d(), (double)(chunk.func_180332_e() + 1), 256.0, (double)(chunk.func_180330_f() + 1)));
            Protection.get(world).addAreaToChunk(chunk, new ProtectionAreaChunk(newArea, controller));
        }
        Protection.get(world).func_76185_a();
        if (!world.field_72995_K) {
            PacketProtectionAdd packet = new PacketProtectionAdd(world, controller, area);
            OpenSecurity.network.sendToDimension((IMessage)packet, world.field_73011_w.getDimension());
        }
        return true;
    }

    private void addAreaToChunk(ChunkPos chunkPos, ProtectionAreaChunk pac) {
        if (!this.chunkAreas.containsKey(chunkPos)) {
            this.chunkAreas.put(chunkPos, new ArrayList());
        }
        this.chunkAreas.get(chunkPos).add(pac);
    }

    public static void removeArea(World world, BlockPos controller) {
        for (ArrayList<ProtectionAreaChunk> areas : Protection.get((World)world).chunkAreas.values()) {
            for (ProtectionAreaChunk area : areas) {
                if (!area.getControllerPosition().equals((Object)controller)) continue;
                areas.remove(area);
                return;
            }
        }
        Protection.get(world).func_76185_a();
        if (!world.field_72995_K) {
            PacketProtectionRemove packet = new PacketProtectionRemove(world, controller);
            OpenSecurity.network.sendToDimension((IMessage)packet, world.field_73011_w.getDimension());
        }
    }

    private void removeAreaFromChunk(ChunkPos chunkPos, AxisAlignedBB area) {
        if (!this.chunkAreas.containsKey(chunkPos)) {
            return;
        }
        this.chunkAreas.get(chunkPos).remove(this.getProtection(area));
    }

    public static boolean updateArea(World world, BlockPos controller, AxisAlignedBB newArea) {
        Protection.removeArea(world, controller);
        return Protection.addArea(world, newArea, controller);
    }

    public void clear() {
        this.chunkAreas = new HashMap();
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.chunkAreas = new HashMap();
        int iC = 0;
        while (nbt.func_74764_b("chunk" + iC)) {
            ArrayList<ProtectionAreaChunk> areaList = new ArrayList<ProtectionAreaChunk>();
            NBTTagCompound chunkTag = nbt.func_74775_l("chunk" + iC);
            int iA = 0;
            while (chunkTag.func_74764_b("area" + iA)) {
                areaList.add(new ProtectionAreaChunk(chunkTag.func_74775_l("area" + iA)));
                ++iA;
            }
            this.chunkAreas.put(new ChunkPos(nbt.func_74762_e("x"), nbt.func_74762_e("z")), areaList);
            ++iC;
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        int iC = 0;
        for (Map.Entry<ChunkPos, ArrayList<ProtectionAreaChunk>> chunkData : this.chunkAreas.entrySet()) {
            NBTTagCompound chunkTag = new NBTTagCompound();
            chunkTag.func_74768_a("x", chunkData.getKey().field_77276_a);
            chunkTag.func_74768_a("z", chunkData.getKey().field_77275_b);
            int iA = 0;
            for (ProtectionAreaChunk area : chunkData.getValue()) {
                chunkTag.func_74782_a("area" + iA++, (NBTBase)area.writeToNBT(new NBTTagCompound()));
            }
            if (iA <= 0) continue;
            compound.func_74782_a("chunk" + iC++, (NBTBase)chunkTag);
        }
        return compound;
    }

    private static ArrayList<ChunkPos> getChunks(AxisAlignedBB area) {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        for (int cX = (int)area.field_72340_a >> 4; cX <= (int)area.field_72336_d >> 4; ++cX) {
            for (int cZ = (int)area.field_72339_c >> 4; cZ <= (int)area.field_72334_f >> 4; ++cZ) {
                chunks.add(new ChunkPos(cX, cZ));
            }
        }
        return chunks;
    }

    private ProtectionAreaChunk getProtection(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        if (!this.chunkAreas.containsKey(chunkPos)) {
            return null;
        }
        for (ProtectionAreaChunk protectedArea : this.chunkAreas.get(chunkPos)) {
            if (!protectedArea.intersects(blockPos)) continue;
            return protectedArea;
        }
        return null;
    }

    private ProtectionAreaChunk getProtection(AxisAlignedBB areaIn) {
        for (ChunkPos chunkPos : Protection.getChunks(areaIn)) {
            if (!this.chunkAreas.containsKey(chunkPos)) continue;
            for (ProtectionAreaChunk protectedArea : this.chunkAreas.get(chunkPos)) {
                if (!protectedArea.intersects(areaIn)) continue;
                return protectedArea;
            }
        }
        return null;
    }

    public static boolean isProtected(Entity entityIn, UserAction action, BlockPos blockPos) {
        if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184812_l_()) {
            return false;
        }
        ProtectionAreaChunk protection = Protection.get(entityIn.field_70170_p).getProtection(blockPos);
        if (protection == null) {
            return false;
        }
        TileEntity controller = entityIn.field_70170_p.func_175625_s(protection.getControllerPosition());
        return controller != null && controller instanceof IProtection && ((IProtection)controller).isProtected(entityIn, action);
    }

    public static boolean isProtected(World world, UserAction action, BlockPos blockPos) {
        ProtectionAreaChunk protection = Protection.get(world).getProtection(blockPos);
        if (protection == null) {
            return false;
        }
        TileEntity controller = world.func_175625_s(protection.getControllerPosition());
        return controller != null && controller instanceof IProtection && ((IProtection)controller).isProtected(null, action);
    }

    private boolean isProtectedArea(AxisAlignedBB areaIn) {
        return this.getProtection(areaIn) != null;
    }

    public static enum UserAction {
        mine,
        explode,
        place,
        interactTE,
        interactHostile,
        interactAnimal;

    }
}

