/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.network.messages;

import ben_mkiv.rendertoolkit.network.EventType;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import ben_mkiv.rendertoolkit.surface.ServerSurface;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEventPacket
implements IMessage {
    public int pentid = -1;
    public int dimId = -1;
    public int targetId = -1;
    public BlockPos pos = new BlockPos(0, 0, 0);
    public Vec3d renderOffset = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d resolution = new Vec3d(0.0, 0.0, 0.0);
    public EventType type;
    public EnumHand hand;
    public int x = -1;
    public int y = -1;
    public int mb = -1;

    public ClientEventPacket() {
    }

    public ClientEventPacket(EventType type, PlayerInteractEvent event) {
        this(type);
        EntityPlayer player = event.getEntityPlayer();
        this.pentid = player.func_145782_y();
        this.dimId = player.field_71093_bK;
        this.pos = event.getPos();
        this.hand = event.getHand();
    }

    public ClientEventPacket(EventType type) {
        this.type = type;
    }

    @SideOnly(value=Side.CLIENT)
    public ClientEventPacket(EventType type, Vec3d renderOffset) {
        this(type);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.pentid = player.func_145782_y();
        this.dimId = player.field_71093_bK;
        this.renderOffset = renderOffset;
    }

    public ClientEventPacket(EventType type, EntityPlayer player, Vec3d mouseData) {
        this(type);
        this.pentid = player.func_145782_y();
        this.dimId = player.field_71093_bK;
        this.x = (int)Math.round(mouseData.field_72450_a);
        this.y = (int)Math.round(mouseData.field_72448_b);
        this.mb = (int)mouseData.field_72449_c;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = EventType.values()[buf.readInt()];
        this.pentid = buf.readInt();
        this.dimId = buf.readInt();
        this.targetId = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        switch (this.type) {
            case GLASSES_SCREEN_SIZE: {
                this.resolution = new Vec3d((double)buf.readInt(), (double)buf.readInt(), (double)buf.readInt());
                this.renderOffset = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
                break;
            }
            case INTERACT_OVERLAY: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.mb = buf.readInt();
                break;
            }
            case INTERACT_WORLD_RIGHT: 
            case INTERACT_WORLD_LEFT: 
            case INTERACT_WORLD_BLOCK_RIGHT: 
            case INTERACT_WORLD_BLOCK_LEFT: {
                this.hand = EnumHand.values()[buf.readInt()];
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.pentid);
        buf.writeInt(this.dimId);
        buf.writeInt(this.targetId);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        switch (this.type) {
            case GLASSES_SCREEN_SIZE: {
                buf.writeInt(ClientSurface.resolution.func_78326_a());
                buf.writeInt(ClientSurface.resolution.func_78328_b());
                buf.writeInt(ClientSurface.resolution.func_78325_e());
                buf.writeDouble(this.renderOffset.field_72450_a);
                buf.writeDouble(this.renderOffset.field_72448_b);
                buf.writeDouble(this.renderOffset.field_72449_c);
                break;
            }
            case INTERACT_OVERLAY: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.mb);
                break;
            }
            case INTERACT_WORLD_RIGHT: 
            case INTERACT_WORLD_LEFT: 
            case INTERACT_WORLD_BLOCK_RIGHT: 
            case INTERACT_WORLD_BLOCK_LEFT: {
                buf.writeInt(this.hand.ordinal());
            }
        }
    }

    public static class Handler
    implements IMessageHandler<ClientEventPacket, IMessage> {
        public IMessage onMessage(ClientEventPacket message, MessageContext ctx) {
            return ServerSurface.instances.onClientEvent(message);
        }
    }
}

