/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container.part;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.container.slot.SlotGhost;
import thaumicenergistics.container.slot.SlotGhostEssentia;
import thaumicenergistics.container.slot.SlotUpgrade;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketEssentiaFilter;
import thaumicenergistics.part.PartSharedEssentiaBus;
import thaumicenergistics.util.EssentiaFilter;

public abstract class ContainerSharedEssentiaBus
extends ContainerBase {
    protected PartSharedEssentiaBus part;

    public ContainerSharedEssentiaBus(EntityPlayer player, PartSharedEssentiaBus part) {
        super(player);
        this.part = part;
        this.sendFilter();
    }

    protected void bindContainerInventory(EssentiaFilter filter, IInventory inventory, int offsetX, int offsetY, int rows, int columns) {
        int i = 0;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                this.func_75146_a(new SlotGhostEssentia(filter, inventory, i, offsetX + x * 18, offsetY + y * 18, this.calculateSlotGroup(i)));
                ++i;
            }
        }
        this.recalculateSlots();
    }

    protected int calculateSlotGroup(int index) {
        return 0;
    }

    protected void bindUpgradesInventory(IItemHandler handler, int offsetX, int offsetY, int count) {
        for (int i = 0; i < count; ++i) {
            this.func_75146_a(new SlotUpgrade(handler, i, offsetX, offsetY + 18 * i){

                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b() instanceof IUpgradeModule && super.func_75214_a(stack);
                }
            });
        }
    }

    @Override
    public void func_75142_b() {
        this.sendFilter();
        this.recalculateSlots();
        super.func_75142_b();
    }

    protected void sendFilter() {
        if (this.getEssentiaFilter() != null && this.player instanceof EntityPlayerMP) {
            PacketHandler.sendToPlayer((EntityPlayerMP)this.player, new PacketEssentiaFilter(this.getEssentiaFilter()));
        }
    }

    public void recalculateSlots() {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotGhost)) continue;
            if (((SlotGhost)slot).getSlotGroup() <= this.getCapacityUpgrades()) {
                ((SlotGhost)slot).setSlotEnabled(true);
                continue;
            }
            ((SlotGhost)slot).setSlotEnabled(false);
        }
    }

    @Override
    public EssentiaFilter getEssentiaFilter() {
        if (this.part == null) {
            return null;
        }
        return this.part.getConfig();
    }

    protected int getCapacityUpgrades() {
        if (this.part == null) {
            return 0;
        }
        return this.part.getInstalledUpgrades(Upgrades.CAPACITY);
    }
}

