/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.recipes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.util.DankNullUtils;

public class RecipeDankNullUpgrade
extends IForgeRegistryEntry.Impl<IRecipe>
implements IShapedRecipe {
    public final NonNullList<Ingredient> recipeItems;
    private NBTTagCompound oldNBT = new NBTTagCompound();

    public RecipeDankNullUpgrade(NonNullList<Ingredient> ingredients) {
        this.recipeItems = ingredients;
    }

    public String func_193358_e() {
        return "danknull:danknullupgrade";
    }

    public ItemStack func_77571_b() {
        return DankNullUtils.getTier(this.getInputDankNull()).getUpgradedVersion(this.getInputDankNull());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public ItemStack getInputDankNull() {
        for (Ingredient item : this.func_192400_c()) {
            if (item.func_193365_a().length <= 0 || !DankNullUtils.isDankNull(item.func_193365_a()[0])) continue;
            return item.func_193365_a()[0];
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int i = 0; i <= 0; ++i) {
            for (int j = 0; j <= 0; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < 3 && l < 3) {
                    ingredient = p_77573_4_ ? (Ingredient)this.recipeItems.get(3 - k - 1 + l * 3) : (Ingredient)this.recipeItems.get(k + l * 3);
                }
                if (ingredient.apply(p_77573_1_.func_70463_b(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!DankNullUtils.isDankNull(inv.func_70301_a(i))) continue;
            this.oldNBT = inv.func_70301_a(i).func_77978_p();
            ItemStack newStack = this.getNewNextTierStack(inv.func_70301_a(i));
            newStack.func_77982_d(this.oldNBT);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getNewNextTierStack(ItemStack dankNull) {
        int tier = DankNullUtils.getMeta(dankNull);
        if (tier < 5) {
            ItemDankNull item = null;
            switch (tier) {
                case 0: {
                    item = ModItems.LAPIS_DANKNULL;
                    break;
                }
                case 1: {
                    item = ModItems.IRON_DANKNULL;
                    break;
                }
                case 2: {
                    item = ModItems.GOLD_DANKNULL;
                    break;
                }
                case 3: {
                    item = ModItems.DIAMOND_DANKNULL;
                    break;
                }
                case 4: {
                    item = ModItems.EMERALD_DANKNULL;
                }
            }
            if (item != null) {
                return new ItemStack((Item)item);
            }
        }
        return ItemStack.field_190927_a;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public static ShapedRecipes deserialize(JsonObject p_193362_0_) {
        String s = JsonUtils.func_151219_a((JsonObject)p_193362_0_, (String)"group", (String)"");
        Map<String, Ingredient> map = RecipeDankNullUpgrade.deserializeKey(JsonUtils.func_152754_s((JsonObject)p_193362_0_, (String)"key"));
        String[] astring = RecipeDankNullUpgrade.shrink(RecipeDankNullUpgrade.patternFromJson(JsonUtils.func_151214_t((JsonObject)p_193362_0_, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = RecipeDankNullUpgrade.deserializeIngredients(astring, map, i, j);
        ItemStack itemstack = RecipeDankNullUpgrade.deserializeItem(JsonUtils.func_152754_s((JsonObject)p_193362_0_, (String)"result"), true);
        return new ShapedRecipes(s, i, j, nonnulllist, itemstack);
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] p_192402_0_, Map<String, Ingredient> p_192402_1_, int p_192402_2_, int p_192402_3_) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(p_192402_2_ * p_192402_3_), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(p_192402_1_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_192402_0_.length; ++i) {
            for (int j = 0; j < p_192402_0_[i].length(); ++j) {
                String s = p_192402_0_[i].substring(j, j + 1);
                Ingredient ingredient = p_192402_1_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_192402_2_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_194134_0_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_194134_0_.length; ++i1) {
            String s = p_194134_0_[i1];
            i = Math.min(i, RecipeDankNullUpgrade.firstNonSpace(s));
            int j1 = RecipeDankNullUpgrade.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_194134_0_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_194134_0_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_194134_0_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray p_192407_0_) {
        String[] astring = new String[p_192407_0_.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JsonUtils.func_151206_a((JsonElement)p_192407_0_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject p_192408_0_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_192408_0_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), RecipeDankNullUpgrade.deserializeIngredient((JsonElement)entry.getValue()));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static Ingredient deserializeIngredient(@Nullable JsonElement p_193361_0_) {
        if (p_193361_0_ != null && !p_193361_0_.isJsonNull()) {
            if (p_193361_0_.isJsonObject()) {
                return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeDankNullUpgrade.deserializeItem(p_193361_0_.getAsJsonObject(), false)});
            }
            if (!p_193361_0_.isJsonArray()) {
                throw new JsonSyntaxException("Expected item to be object or array of objects");
            }
            JsonArray jsonarray = p_193361_0_.getAsJsonArray();
            if (jsonarray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            ItemStack[] aitemstack = new ItemStack[jsonarray.size()];
            for (int i = 0; i < jsonarray.size(); ++i) {
                aitemstack[i] = RecipeDankNullUpgrade.deserializeItem(JsonUtils.func_151210_l((JsonElement)jsonarray.get(i), (String)"item"), false);
            }
            return Ingredient.func_193369_a((ItemStack[])aitemstack);
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static ItemStack deserializeItem(JsonObject p_192405_0_, boolean useCount) {
        String s = JsonUtils.func_151200_h((JsonObject)p_192405_0_, (String)"item");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + s + "'");
        }
        if (item.func_77614_k() && !p_192405_0_.has("data")) {
            throw new JsonParseException("Missing data for item '" + s + "'");
        }
        int i = JsonUtils.func_151208_a((JsonObject)p_192405_0_, (String)"data", (int)0);
        int j = useCount ? JsonUtils.func_151208_a((JsonObject)p_192405_0_, (String)"count", (int)1) : 1;
        return new ItemStack(item, j, i);
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }
}

