/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.gui;

import com.buuz135.thaumicjei.config.ThaumicConfig;
import com.buuz135.thaumicjei.util.AspectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

@Mod.EventBusSubscriber(modid="thaumicjei", value={Side.CLIENT})
public class AspectTooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tooltipEvent(ItemTooltipEvent event) {
        if (!ThaumicConfig.forceAspectTooltipInAllGUI) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        GuiScreen gui = mc.field_71462_r;
        if (!(gui instanceof GuiContainer) && GuiScreen.func_146272_n() != ModConfig.CONFIG_GRAPHICS.showTags) {
            int width;
            AspectList tags = ThaumcraftCraftingManager.getObjectTags((ItemStack)event.getItemStack());
            if (tags == null) {
                return;
            }
            int index = 0;
            if (tags.size() > 0) {
                for (Aspect aspect : tags.getAspects()) {
                    if (aspect == null) continue;
                    ++index;
                }
            }
            if ((width = index * 18) > 0) {
                double spaceWidth = mc.field_71466_p.func_78256_a(" ");
                int spaceAmount = MathHelper.func_76143_f((double)((double)width / spaceWidth));
                int heightAmount = MathHelper.func_76143_f((double)(18.0 / (double)mc.field_71466_p.field_78288_b));
                for (int a = 0; a < heightAmount; ++a) {
                    event.getToolTip().add("                                                                                                                                            ".substring(0, Math.min(120, spaceAmount)));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tooltipEvent(RenderTooltipEvent.PostBackground event) {
        if (!ThaumicConfig.forceAspectTooltipInAllGUI) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        GuiScreen gui = mc.field_71462_r;
        if (!(gui instanceof GuiContainer) && GuiScreen.func_146272_n() != ModConfig.CONFIG_GRAPHICS.showTags && !Mouse.isGrabbed()) {
            int bot = event.getHeight();
            if (!event.getLines().isEmpty()) {
                for (int a = event.getLines().size() - 1; a >= 0; --a) {
                    if (event.getLines().get(a) != null && !((String)event.getLines().get(a)).contains("    ")) {
                        bot -= 10;
                        continue;
                    }
                    if (a <= 0 || event.getLines().get(a - 1) == null || !((String)event.getLines().get(a - 1)).contains("    ")) continue;
                    AspectTooltipHandler.renderAspectsInGui(event.getStack(), bot, event.getX(), event.getY());
                    break;
                }
            }
        }
    }

    public static void renderAspectsInGui(ItemStack stack, int botY, int posX, int posY) {
        AspectList tags = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
        if (tags != null) {
            GL11.glPushMatrix();
            int pos = 0;
            if (tags.size() > 0) {
                Aspect[] sortedTags;
                for (Aspect sortedTag : sortedTags = tags.getAspectsSortedByAmount()) {
                    AspectUtils.renderAspectList(new AspectList().add(sortedTag, tags.getAmount(sortedTag)), posX + pos * 19, posY + botY - 16, Minecraft.func_71410_x());
                    ++pos;
                }
            }
            GL11.glPopMatrix();
        }
    }
}

