/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.books;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pcl.openprinter.books.BookChapter;
import pcl.openprinter.books.BookPage;
import pcl.openprinter.books.GenericBook;

public class BiblioCraftBigBook
extends GenericBook {
    @Override
    public HashMap<String, Object> get() {
        HashMap<String, Object> output = super.get();
        ArrayList<HashMap<String, Object>> chapterData = new ArrayList<HashMap<String, Object>>();
        for (BookChapter chapter : this.chapters) {
            chapterData.add(chapter.toMap());
        }
        output.put("chapters", chapterData);
        return output;
    }

    public Object[] readFromStack(ItemStack book) {
        if (!book.func_77942_o() || !book.func_77978_p().func_74764_b("pages")) {
            return new Object[]{false, "book doesnt have nbt data"};
        }
        NBTTagCompound nbt = book.func_77978_p();
        this.isSigned = nbt.func_74764_b("signed");
        if (this.isSigned) {
            this.title = nbt.func_74775_l("display").func_74779_i("Name");
            this.author = nbt.func_74779_i("author");
        }
        NBTTagCompound pagesNBT = nbt.func_74775_l("pages");
        for (int i = 0; i < nbt.func_74762_e("pagesTotal"); ++i) {
            BookPage page = new BookPage(i + 1);
            NBTTagList tags = pagesNBT.func_150295_c("page" + i, 8);
            int[] lineScale = pagesNBT.func_74759_k("pageScale" + i);
            for (int j = 0; j < tags.func_74745_c(); ++j) {
                String line = tags.func_150307_f(j);
                if (line.length() <= 0) continue;
                page.addLine(line, j + 1, lineScale[j]);
            }
            this.addPage(page);
        }
        NBTTagCompound chaptersNBT = nbt.func_74775_l("chapters");
        int[] chapters = chaptersNBT.func_74759_k("chapBools");
        int[] chaptersPages = chaptersNBT.func_74759_k("chapPages");
        HashMap chapterOutput = new HashMap();
        for (int chapter = 0; chapter < chapters.length; ++chapter) {
            if (chapters[chapter] != 1) continue;
            ArrayList<String> titles = new ArrayList<String>();
            String title1 = chaptersNBT.func_74779_i("chapline" + chapter * 2);
            String title2 = chaptersNBT.func_74779_i("chapline" + (chapter * 2 + 1));
            if (title1.length() > 0) {
                titles.add(title1);
            }
            if (title2.length() > 0) {
                titles.add(title2);
            }
            this.addChapter(new BookChapter(1 + chaptersPages[chapter], titles));
        }
        return new Object[]{this.get()};
    }
}

