/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDarkCreeper
extends Entity_SpecialCreeper {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityDarkCreeper.GET_TEXTURE_PATH("dark")), new ResourceLocation(EntityDarkCreeper.GET_TEXTURE_PATH("dark_eyes"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(16383802);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityDarkCreeper.ADD_BASE_LOOT(loot);
        loot.addClusterDrop("common", "Torches", Blocks.field_150478_aa);
        loot.addRareDrop("rare", "Night vision potion", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185234_f));
    }

    public EntityDarkCreeper(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        ++this.field_70728_aV;
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g / 2.0f * (powered ? 2.0f : 1.0f);
        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, false, griefing);
        if (ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
            return;
        }
        explosion.func_77278_a();
        BlockPos center = new BlockPos((Entity)this);
        int radius = this.field_82226_g * 4 * (powered ? 2 : 1);
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    IBlockState block;
                    if (x * x + y * y + z * z > radius * radius || (block = this.field_70170_p.func_180495_p(pos = center.func_177982_a(x, y, z))).getLightValue((IBlockAccess)this.field_70170_p, pos) <= 1 || explosion.func_180343_e().contains(pos)) continue;
                    float blockDamage = (float)radius * (0.7f + this.field_70146_Z.nextFloat() * 0.6f);
                    if (block.func_185904_a() != Material.field_151579_a) {
                        blockDamage -= (this.func_180428_a(explosion, this.field_70170_p, pos, block) + 0.3f) * 0.3f;
                    }
                    if (!(blockDamage > 0.0f) || !this.func_174816_a(explosion, this.field_70170_p, pos, block, blockDamage)) continue;
                    explosion.func_180343_e().add(pos);
                }
            }
        }
        explosion.func_77279_a(true);
        if (powered) {
            long time = this.field_70170_p.func_72820_D();
            int dayTime = (int)(time % 24000L);
            time -= (long)dayTime;
            time = dayTime <= 13000 ? (time += 13000L) : (time += 37000L);
            this.field_70170_p.func_72877_b(time);
        }
    }

    @Override
    public boolean alwaysMakePotionCloud() {
        return true;
    }

    @Override
    public void potionCloudByType(EntityAreaEffectCloud potionCloud, boolean powered) {
        super.potionCloudByType(potionCloud, powered);
        potionCloud.func_184496_a(new PotionEffect(MobEffects.field_76440_q, 100));
    }
}

