/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.items;

import engineers.workshop.EngineersWorkshop;
import engineers.workshop.common.Config;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum Upgrade {
    BLANK(new MaxCount(0), ParentType.NULL),
    AUTO_CRAFTER(new MaxCount(1), ParentType.CRAFTING),
    STORAGE(new MaxCount(1), ParentType.CRAFTING),
    CHARGED((MaxCount)new ConfigurableMax(8), ParentType.access$100()),
    SPEED((MaxCount)new ConfigurableMax(8), ParentType.access$100()),
    QUEUE(new MaxCount(3), EnumSet.of(ParentType.CRUSHING, ParentType.SMELTING)),
    AUTO_TRANSFER(new MaxCount(1), ParentType.GLOBAL),
    FILTER(new MaxCount(1), ParentType.GLOBAL),
    TRANSFER((MaxCount)new ConfigurableMax(6, 20), ParentType.GLOBAL),
    AXE(new MaxCount(1), ParentType.CRUSHING);

    private String name;
    private String description;
    private MaxCount maxCount;
    private EnumSet<ParentType> validParents;
    private Upgrade dep;

    private Upgrade(MaxCount maxCount, EnumSet<ParentType> validParents, Upgrade dep) {
        this.validParents = validParents;
        this.name = this.toString().toLowerCase();
        this.description = String.format("engineersworkshop:upgrade.%s.description", this.name);
        this.maxCount = maxCount;
        maxCount.init(this);
        this.dep = dep;
    }

    private Upgrade(MaxCount maxCount, EnumSet<ParentType> validParents) {
        this(maxCount, validParents, null);
    }

    private Upgrade(MaxCount maxCount, ParentType type) {
        this(maxCount, type == null ? EnumSet.of(ParentType.NULL) : EnumSet.of(type), null);
    }

    private Upgrade(MaxCount maxCount, ParentType type, Upgrade dep) {
        this(maxCount, type == null ? EnumSet.of(ParentType.NULL) : EnumSet.of(type), dep);
    }

    public static ItemStack getInvalidItemStack() {
        return new ItemStack(EngineersWorkshop.itemUpgrade, 1, Upgrade.values().length);
    }

    public Upgrade getDependency() {
        return this.dep;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.maxCount.getConfigurableMax() == 0 || this.maxCount.getMax() > 0;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack(EngineersWorkshop.itemUpgrade, 1, this.ordinal());
    }

    public void addInfo(List<String> info) {
        info.add(I18n.func_135052_a((String)this.description, (Object[])new Object[0]));
        if (!GuiScreen.func_146272_n() && !GuiScreen.func_146271_m()) {
            info.add(I18n.func_135052_a((String)"<hold shift for stack info>", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"<hold control for parent info>", (Object[])new Object[0]));
        }
        if (GuiScreen.func_146272_n()) {
            if (this.getMaxCount() == 1) {
                info.add(I18n.func_135052_a((String)"engineersworkshop:upgrade.unstackable", (Object[])new Object[0]));
            } else if (this.getMaxCount() > 1) {
                info.add(I18n.func_135052_a((String)"engineersworkshop:upgrade.stackable", (Object[])new Object[]{this.getMaxCount()}));
            }
            info.addAll(this.validParents.stream().map(validParent -> I18n.func_135052_a((String)((ParentType)validParent).description, (Object[])new Object[0])).collect(Collectors.toList()));
        }
        if (GuiScreen.func_146271_m() && this.validParents.size() > 0) {
            info.add("Parents: ");
            info.addAll(this.validParents.stream().map(Enum::name).collect(Collectors.toList()));
        }
    }

    public boolean isValid(@Nonnull ItemStack parent) {
        for (ParentType validParent : this.validParents) {
            if (!validParent.isValidParent(parent)) continue;
            return true;
        }
        return false;
    }

    public int getMaxCount() {
        return this.maxCount.getMax();
    }

    public MaxCount getMaxCountObject() {
        return this.maxCount;
    }

    private static class ConfigurableMax
    extends MaxCount {
        private static final int GLOBAL_MAX_COUNT = 512;
        private static final int MAX_COUNT = 448;
        private boolean isGlobal;
        private int configurableMax;

        private ConfigurableMax(int max, int configurableMax) {
            super(max);
            this.configurableMax = configurableMax;
        }

        private ConfigurableMax(int max) {
            this(max, -1);
        }

        @Override
        public int getConfigurableMax() {
            return this.configurableMax != -1 ? this.configurableMax : (this.isGlobal ? 512 : 448);
        }

        @Override
        public void init(Upgrade upgrade) {
            this.isGlobal = upgrade.validParents.contains((Object)ParentType.GLOBAL);
        }
    }

    public static class MaxCount {
        private int max;
        private int defaultMax;

        public MaxCount(int max) {
            this.max = max;
            this.defaultMax = max;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int value) {
            this.max = value;
        }

        public int getConfigurableMax() {
            return this.defaultMax;
        }

        public void init(Upgrade upgrade) {
        }
    }

    public static enum ParentType {
        CRAFTING("Works with Crafting Tables"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                if (!item.func_190926_b()) {
                    for (String parent : Config.MACHINES.CRAFTER_BLOCKS) {
                        String[] _s = parent.replace(",", "").split("/");
                        String regName = parent;
                        int meta = -1;
                        if (_s.length > 1) {
                            regName = _s[0];
                            meta = Integer.parseInt(_s[1]);
                        }
                        if (!item.func_77973_b().getRegistryName().toString().equals(regName) || meta != -1 && item.func_77960_j() != meta) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        SMELTING("Works with Furnaces"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                if (!item.func_190926_b()) {
                    for (String parent : Config.MACHINES.FURNACE_BLOCKS) {
                        String[] _s = parent.replace(",", "").split("/");
                        String regName = parent;
                        int meta = -1;
                        if (_s.length > 1) {
                            regName = _s[0];
                            meta = Integer.parseInt(_s[1]);
                        }
                        if (!item.func_77973_b().getRegistryName().toString().equals(regName) || meta != -1 && item.func_77960_j() != meta) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        CRUSHING("Works with Crushers"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                if (!item.func_190926_b()) {
                    for (String parent : Config.MACHINES.CRUSHER_BLOCKS) {
                        String[] _s = parent.replace(",", "").split("/");
                        String regName = parent;
                        int meta = -1;
                        if (_s.length > 1) {
                            regName = _s[0];
                            meta = Integer.parseInt(_s[1]);
                        }
                        if (!item.func_77973_b().getRegistryName().toString().equals(regName) || meta != -1 && item.func_77960_j() != meta) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        ALLOY("Works with Alloy Smelters"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                if (!item.func_190926_b()) {
                    for (String parent : Config.MACHINES.ALLOY_BLOCKS) {
                        String[] _s = parent.replace(",", "").split("/");
                        String regName = parent;
                        int meta = -1;
                        if (_s.length > 1) {
                            regName = _s[0];
                            meta = Integer.parseInt(_s[1]);
                        }
                        if (!item.func_77973_b().getRegistryName().toString().equals(regName) || meta != -1 && item.func_77960_j() != meta) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        STORAGE("Works with Chests"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                if (item.func_190926_b()) {
                    return false;
                }
                for (String parent : Config.MACHINES.STORAGE_BLOCKS) {
                    String[] _s = parent.replace(",", "").split("/");
                    String regName = parent;
                    int meta = -1;
                    if (_s.length > 1) {
                        regName = _s[0];
                        meta = Integer.parseInt(_s[1]);
                    }
                    if (!item.func_77973_b().getRegistryName().toString().equals(regName) || meta != -1 && item.func_77960_j() != meta) continue;
                    return true;
                }
                int[] nArray = OreDictionary.getOreIDs((ItemStack)item);
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer id = nArray[i];
                    if (!OreDictionary.getOreName((int)id).equals("chest")) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        GLOBAL("Upgrades the entire Table"){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                return item.func_190926_b();
            }
        }
        ,
        NULL("you shouldn't be seeing this."){

            @Override
            public boolean isValidParent(@Nonnull ItemStack item) {
                return false;
            }
        };

        private static final EnumSet<ParentType> MachineSet;
        private String description;

        private ParentType(String description) {
            this.description = description;
        }

        public abstract boolean isValidParent(@Nonnull ItemStack var1);

        static /* synthetic */ EnumSet access$100() {
            return MachineSet;
        }

        static {
            MachineSet = EnumSet.of(CRAFTING, SMELTING, CRUSHING, ALLOY);
        }
    }
}

