/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.manual;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public abstract class ManualContentProvider {
    private static final String regExImageTag = "!\\[[^]]*]\\((http|https)://[^)]*\\)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<String> getContent(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        if (path.contains("#")) {
            path = path.substring(0, path.indexOf("#"));
        }
        InputStream is = null;
        try {
            String line;
            is = this.getClass().getClassLoader().getResourceAsStream(path + ".md");
            BufferedReader reader22 = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
            boolean inCodeBlock = false;
            while ((line = reader22.readLine()) != null) {
                if (line.toLowerCase().contains("screenshot")) continue;
                if ((line = line.replaceAll(regExImageTag, "")).contains("```")) {
                    line = line.replaceAll("```lua", "").replaceAll("```", "");
                    boolean bl = inCodeBlock = !inCodeBlock;
                }
                if (inCodeBlock) {
                    line = "`" + line + "`";
                }
                lines.add(line);
            }
            if (is == null) return lines;
        }
        catch (Throwable ignored) {
            try {
                Iterable<String> iterable = null;
                return iterable;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            is.close();
            return lines;
        }
        catch (IOException reader22) {
            return lines;
        }
    }
}

