/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.component;

import ben_mkiv.rendertoolkit.common.widgets.Widget;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class WidgetList {
    HashMap<Integer, Widget> list = new HashMap();

    public int getNextWidgetID() {
        int maxID = 0;
        for (int widgetID : this.list.keySet()) {
            maxID = Math.max(maxID, widgetID);
        }
        return maxID + 1;
    }

    public int add(Widget widget) {
        int id = this.getNextWidgetID();
        this.list.put(id, widget);
        return id;
    }

    public Widget get(int widgetID) {
        return this.list.get(widgetID);
    }

    public boolean removeWidget(int id) {
        return this.list.containsKey(id) && this.list.remove(id) != null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        int size = this.list.size();
        nbt.func_74768_a("listSize", size);
        int i = 0;
        for (Map.Entry<Integer, Widget> e : this.list.entrySet()) {
            NBTTagCompound widget = new NBTTagCompound();
            widget.func_74768_a("widgetType", e.getValue().getType().ordinal());
            widget.func_74768_a("ID", e.getKey().intValue());
            NBTTagCompound wNBT = new NBTTagCompound();
            e.getValue().writeToNBT(wNBT);
            widget.func_74782_a("widget", (NBTBase)wNBT);
            tag.func_74782_a(String.valueOf(i), (NBTBase)widget);
            ++i;
        }
        nbt.func_74782_a("widgetList", (NBTBase)tag);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.list.clear();
        if (nbt.func_74764_b("widgetList") && nbt.func_74764_b("listSize")) {
            NBTTagCompound nbtList = (NBTTagCompound)nbt.func_74781_a("widgetList");
            for (int i = 0; i < nbt.func_74762_e("listSize"); ++i) {
                NBTTagCompound wiget;
                if (!nbtList.func_74764_b(String.valueOf(i)) || !(wiget = (NBTTagCompound)nbtList.func_74781_a(String.valueOf(i))).func_74764_b("widgetType") || !wiget.func_74764_b("widget") || !wiget.func_74764_b("ID")) continue;
                Widget newWidget = Widget.create((int)wiget.func_74762_e("widgetType"));
                newWidget.readFromNBT((NBTTagCompound)wiget.func_74781_a("widget"));
                this.list.put(wiget.func_74762_e("ID"), newWidget);
            }
        }
    }
}

