/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.lib.McJty.font;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class TrueTypeFont {
    public int usageCount = 0;
    private FloatObject[] charArray = new FloatObject[256];
    private Map<Character, FloatObject> customChars = new HashMap<Character, FloatObject>();
    protected boolean antiAlias;
    private float fontSize = 0.0f;
    private float fontHeight = 0.0f;
    private int fontTextureID;
    private int textureWidth = 1024;
    private int textureHeight = 1024;
    protected Font font;
    private FontMetrics fontMetrics;
    private int correctL = 9;
    private int correctR = 8;

    public Font getFont() {
        return this.font;
    }

    public boolean getAntialias() {
        return this.antiAlias;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public String getFontName() {
        return this.font.getName();
    }

    public TrueTypeFont(Font font, boolean antiAlias, char[] additionalChars) {
        this.font = font;
        this.fontSize = font.getSize();
        this.antiAlias = antiAlias;
        this.createSet(additionalChars);
        System.out.println("TrueTypeFont loaded: " + font + " - AntiAlias = " + antiAlias);
        this.fontHeight -= 1.0f;
        if (this.fontHeight <= 0.0f) {
            this.fontHeight = 1.0f;
        }
    }

    public TrueTypeFont(Font font, boolean antiAlias) {
        this(font, antiAlias, null);
    }

    private BufferedImage getFontImage(char ch) {
        float charheight;
        BufferedImage tempfontImage = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)tempfontImage.getGraphics();
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        float charwidth = this.fontMetrics.charWidth(ch) + 8;
        if (charwidth <= 0.0f) {
            charwidth = 7.0f;
        }
        if ((charheight = (float)(this.fontMetrics.getHeight() + 3)) <= 0.0f) {
            charheight = this.fontSize;
        }
        BufferedImage fontImage = new BufferedImage((int)charwidth, (int)charheight, 2);
        Graphics2D gt = (Graphics2D)fontImage.getGraphics();
        if (this.antiAlias) {
            gt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        gt.setFont(this.font);
        gt.setColor(Color.WHITE);
        int charX = 3;
        int charY = 1;
        gt.drawString(String.valueOf(ch), charX, charY + this.fontMetrics.getAscent());
        return fontImage;
    }

    private void createSet(char[] customCharsArray) {
        if (customCharsArray != null && customCharsArray.length > 0) {
            this.textureWidth *= 2;
        }
        try {
            BufferedImage imgTemp = new BufferedImage(this.textureWidth, this.textureHeight, 2);
            Graphics2D g = (Graphics2D)imgTemp.getGraphics();
            g.setColor(new Color(0, 0, 0, 1));
            g.fillRect(0, 0, this.textureWidth, this.textureHeight);
            float rowHeight = 0.0f;
            float positionX = 0.0f;
            float positionY = 0.0f;
            int customCharsLength = customCharsArray != null ? customCharsArray.length : 0;
            for (int i = 0; i < 256 + customCharsLength; ++i) {
                char ch = i < 256 ? (char)i : customCharsArray[i - 256];
                BufferedImage fontImage = this.getFontImage(ch);
                FloatObject newIntObject = new FloatObject();
                newIntObject.width = fontImage.getWidth();
                newIntObject.height = fontImage.getHeight();
                if (positionX + newIntObject.width >= (float)this.textureWidth) {
                    positionX = 0.0f;
                    positionY += rowHeight;
                    rowHeight = 0.0f;
                }
                newIntObject.storedX = positionX;
                newIntObject.storedY = positionY;
                if (newIntObject.height > this.fontHeight) {
                    this.fontHeight = newIntObject.height;
                }
                if (newIntObject.height > rowHeight) {
                    rowHeight = newIntObject.height;
                }
                g.drawImage((Image)fontImage, (int)positionX, (int)positionY, null);
                positionX += newIntObject.width;
                if (i < 256) {
                    this.charArray[i] = newIntObject;
                    continue;
                }
                this.customChars.put(new Character(ch), newIntObject);
            }
            this.fontTextureID = TrueTypeFont.loadImage(imgTemp);
        }
        catch (RuntimeException e) {
            System.err.println("Failed to create font.");
            e.printStackTrace();
        }
    }

    private void drawQuad(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2) {
        float DrawWidth = drawX2 - drawX;
        float DrawHeight = drawY2 - drawY;
        float TextureSrcX = srcX / (float)this.textureWidth;
        float TextureSrcY = srcY / (float)this.textureHeight;
        float SrcWidth = srcX2 - srcX;
        float SrcHeight = srcY2 - srcY;
        float RenderWidth = SrcWidth / (float)this.textureWidth;
        float RenderHeight = SrcHeight / (float)this.textureHeight;
        GL11.glTexCoord2f((float)TextureSrcX, (float)TextureSrcY);
        GL11.glVertex2f((float)drawX, (float)drawY);
        GL11.glTexCoord2f((float)TextureSrcX, (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)drawX, (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)TextureSrcY);
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)drawY);
    }

    public float getWidth(String whatchars) {
        float totalwidth = 0.0f;
        char currentChar = '\u0000';
        float lastWidth = -10.0f;
        for (int i = 0; i < whatchars.length(); ++i) {
            currentChar = whatchars.charAt(i);
            FloatObject floatObject = currentChar < '\u0100' ? this.charArray[currentChar] : this.customChars.get(new Character(currentChar));
            if (floatObject == null) continue;
            totalwidth += floatObject.width / 2.0f;
            lastWidth = floatObject.width;
        }
        return this.fontMetrics.stringWidth(whatchars);
    }

    public float getHeight() {
        return this.fontHeight;
    }

    public float getHeight(String HeightString) {
        return this.fontHeight;
    }

    public float getLineHeight() {
        return this.fontHeight;
    }

    public String trimStringToWidth(String text, int width) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        int j = 0;
        int k = 1;
        boolean flag = false;
        boolean flag1 = false;
        for (int l = j; l >= 0 && l < text.length() && i < width; l += k) {
            char c0 = text.charAt(l);
            int i1 = (int)this.getWidth("" + c0);
            if (flag) {
                flag = false;
                if (c0 != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag1 = false;
                    }
                } else {
                    flag1 = true;
                }
            } else if (i1 < 0) {
                flag = true;
            } else {
                i += i1;
                if (flag1) {
                    ++i;
                }
            }
            if (i > width) break;
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawString(String text, float x, float y, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.getLineHeight(), (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color & 0xFF) / 255.0f;
        float blue = (float)(color >> 8 & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)blue, (float)green, (float)alpha);
        GlStateManager.func_179144_i((int)this.fontTextureID);
        GlStateManager.func_187447_r((int)7);
        this.drawTextInternal(text);
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void drawTextInternal(String whatchars) {
        float totalwidth = 0.0f;
        for (int i = 0; i < whatchars.length(); ++i) {
            char charCurrent = whatchars.charAt(i);
            FloatObject floatObject = charCurrent < '\u0100' ? this.charArray[charCurrent] : this.customChars.get(new Character(charCurrent));
            if (floatObject == null) continue;
            this.drawQuad(totalwidth + floatObject.width, 0.0f, totalwidth, floatObject.height, floatObject.storedX + floatObject.width, floatObject.storedY + floatObject.height, floatObject.storedX, floatObject.storedY);
            totalwidth += floatObject.width - (float)this.correctL;
        }
    }

    public static int loadImage(BufferedImage bufferedImage) {
        try {
            ByteBuffer byteBuffer;
            short width = (short)bufferedImage.getWidth();
            short height = (short)bufferedImage.getHeight();
            byte bpp = (byte)bufferedImage.getColorModel().getPixelSize();
            DataBuffer db = bufferedImage.getData().getDataBuffer();
            if (db instanceof DataBufferInt) {
                int[] intI = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                byte[] newI = new byte[intI.length * 4];
                for (int i = 0; i < intI.length; ++i) {
                    byte[] b = TrueTypeFont.intToByteArray(intI[i]);
                    int newIndex = i * 4;
                    newI[newIndex] = b[1];
                    newI[newIndex + 1] = b[2];
                    newI[newIndex + 2] = b[3];
                    newI[newIndex + 3] = b[0];
                }
                byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(newI);
            } else {
                byteBuffer = ByteBuffer.allocateDirect(width * height * (bpp / 8)).order(ByteOrder.nativeOrder()).put(((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData());
            }
            byteBuffer.flip();
            int internalFormat = 32856;
            int format = 6408;
            IntBuffer textureId = BufferUtils.createIntBuffer((int)1);
            GL11.glGenTextures((IntBuffer)textureId);
            GL11.glBindTexture((int)3553, (int)textureId.get(0));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
            GLU.gluBuild2DMipmaps((int)3553, (int)internalFormat, (int)width, (int)height, (int)format, (int)5121, (ByteBuffer)byteBuffer);
            return textureId.get(0);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isSupported(String fontname) {
        Font[] font = TrueTypeFont.getFonts();
        for (int i = font.length - 1; i >= 0; --i) {
            if (!font[i].getName().equalsIgnoreCase(fontname)) continue;
            return true;
        }
        return false;
    }

    public static Font[] getFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public void destroy() {
        IntBuffer scratch = BufferUtils.createIntBuffer((int)1);
        scratch.put(0, this.fontTextureID);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glDeleteTextures((IntBuffer)scratch);
    }

    private class FloatObject {
        public float width;
        public float height;
        public float storedX;
        public float storedY;

        private FloatObject() {
        }
    }
}

