/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import ben_mkiv.rendertoolkit.surface.ServerSurface;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.component.OpenGlassesHostComponent;
import com.bymarcin.openglasses.event.minecraft.server.ServerEventHandler;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.item.upgrades.UpgradeNightvision;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.utils.PlayerStatsOC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OCServerSurface
extends ServerSurface {
    public static HashMap<UUID, UUID> playerGlasses;
    public static HashMap<UUID, OpenGlassesHostComponent> components;

    public OCServerSurface() {
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
    }

    public static OCServerSurface instance() {
        return (OCServerSurface)instances;
    }

    public static void onServerStopped() {
        components.clear();
        playerGlasses.clear();
        OCServerSurface.instance().players.clear();
        OCServerSurface.instance().playerStats.clear();
    }

    public static void removeHost(UUID hostUUID) {
        if (components.containsKey(hostUUID)) {
            components.get(hostUUID).remove();
            components.remove(hostUUID);
        }
    }

    public static void addHost(OpenGlassesHostComponent component) {
        if (!components.containsKey(component.getUUID())) {
            components.put(component.getUUID(), component);
            for (Map.Entry entry : OCServerSurface.instance().players.entrySet()) {
                component.sync(OCServerSurface.instance().checkUUID((UUID)entry.getKey()));
            }
        }
    }

    public static OpenGlassesHostComponent getHost(UUID hostUUID) {
        return components.get(hostUUID);
    }

    public boolean isSubscribedTo(UUID playerUUID, UUID hostUUID) {
        return this.players.containsKey(playerUUID) && ((HashSet)this.players.get(playerUUID)).contains(hostUUID);
    }

    public void subscribePlayer(EntityPlayerMP player, UUID hostUUID) {
        NetworkRegistry.packetHandler.sendTo((IMessage)new TerminalStatusPacket(TerminalStatusPacket.TerminalEvent.GLASSES_EQUIPPED, UUID.randomUUID()), player);
        playerGlasses.remove(player.func_110124_au());
        ItemStack glassesStack = OpenGlasses.getGlassesStack((EntityPlayer)player);
        if (!glassesStack.func_190926_b()) {
            UUID glassesUUID = GlassesNBT.getUniqueId(glassesStack);
            playerGlasses.put(player.func_110124_au(), glassesUUID);
            OCServerSurface.getStats((EntityPlayerMP)player).conditions.bufferSensors(OpenGlasses.getGlassesStack((EntityPlayer)player));
        }
        if (this.isSubscribedTo(player.func_110124_au(), hostUUID)) {
            return;
        }
        if (!this.players.containsKey(player.func_110124_au())) {
            this.players.put(player.func_110124_au(), new HashSet());
        }
        ((HashSet)this.players.get(player.func_110124_au())).add(hostUUID);
        if (!glassesStack.func_190926_b()) {
            OpenGlassesHostComponent host = OCServerSurface.getHost(hostUUID);
            if (host != null) {
                host.onGlassesPutOn(player);
            }
            this.requestResolutionEvent(player, hostUUID);
        }
    }

    public void unsubscribePlayer(EntityPlayerMP player) {
        NetworkRegistry.packetHandler.sendTo((IMessage)new TerminalStatusPacket(TerminalStatusPacket.TerminalEvent.GLASSES_UNEQUIPPED, UUID.randomUUID()), player);
        if (OCServerSurface.getStats((EntityPlayerMP)player).nightVisionActive) {
            player.func_184589_d(UpgradeNightvision.potionNightvision);
        }
        if (!this.players.containsKey(player.func_110124_au())) {
            return;
        }
        for (UUID hostUUID : (HashSet)this.players.get(player.func_110124_au())) {
            OpenGlassesHostComponent host = OCServerSurface.getHost(hostUUID);
            if (host == null) continue;
            host.onGlassesPutOff(player);
        }
        this.players.remove(player.func_110124_au());
        playerGlasses.remove(player.func_110124_au());
    }

    public static void equipmentChanged(EntityPlayerMP player, ItemStack newStack) {
        ItemStack glassesStackBaubles;
        UUID oldUUID = playerGlasses.getOrDefault(player.func_110124_au(), null);
        UUID newUUID = null;
        if (!OpenGlasses.isGlassesStack(newStack) && playerGlasses.containsKey(player.func_110124_au()) && !(glassesStackBaubles = OpenGlasses.getGlassesStack((EntityPlayer)player)).func_190926_b()) {
            newStack = glassesStackBaubles;
        }
        if (OpenGlasses.isGlassesStack(newStack) && (newUUID = GlassesNBT.getUniqueId(newStack)).equals(oldUUID)) {
            return;
        }
        if (oldUUID != null) {
            OCServerSurface.instance().unsubscribePlayer(player);
        }
        if (newUUID != null) {
            for (NBTTagCompound nbt : OpenGlassesHostsNBT.getHostsFromNBT(newStack)) {
                OCServerSurface.instance().subscribePlayer(player, nbt.func_186857_a("host"));
            }
        }
    }

    public static PlayerStatsOC getStats(EntityPlayerMP player) {
        if (!OCServerSurface.instance().playerStats.containsKey(player.func_110124_au())) {
            OCServerSurface.instance().playerStats.put(player.func_110124_au(), new PlayerStatsOC((EntityPlayer)player));
        }
        return (PlayerStatsOC)((Object)OCServerSurface.instance().playerStats.get(player.func_110124_au()));
    }

    public void requestResolutionEvent(EntityPlayerMP player, UUID instanceUUID) {
        if (player != null) {
            NetworkRegistry.packetHandler.sendTo((IMessage)new TerminalStatusPacket(TerminalStatusPacket.TerminalEvent.ASYNC_SCREEN_SIZES, instanceUUID), player);
        }
    }

    static {
        instances = new OCServerSurface();
        playerGlasses = new HashMap();
        components = new HashMap();
    }
}

