/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.utils;

import ben_mkiv.commons0815.utils.utilsCommon;
import com.bymarcin.openglasses.item.upgrades.UpgradeDaylightDetector;
import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.item.upgrades.UpgradeMotionSensor;
import com.bymarcin.openglasses.item.upgrades.UpgradeNavigation;
import com.bymarcin.openglasses.item.upgrades.UpgradeTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class Conditions {
    private boolean hasMotionSensor;
    private boolean hasGeolyzer;
    private boolean hasLightSensor;
    private boolean hasRainSensor;
    public boolean hasNavigation;
    private boolean overlayActive = false;
    private long lastExtendedConditionCheck = 0L;
    private long conditionStates = 0L;

    public void bufferSensors(ItemStack glassesStack) {
        this.hasMotionSensor = UpgradeMotionSensor.hasUpgrade(glassesStack);
        this.hasGeolyzer = UpgradeGeolyzer.hasUpgrade(glassesStack);
        this.hasRainSensor = UpgradeTank.hasUpgrade(glassesStack);
        this.hasLightSensor = UpgradeDaylightDetector.hasUpgrade(glassesStack);
        this.hasNavigation = UpgradeNavigation.hasUpgrade(glassesStack);
    }

    public long getConditionStates(EntityPlayer player) {
        long curConditionStates = 0L;
        long checkConditions = -1L;
        curConditionStates = this.overlayActive ? (curConditionStates |= 0x80L) : (curConditionStates |= 0x100L);
        if (this.hasMotionSensor && ((checkConditions >>> 5 & 1L) != 0L || (checkConditions >>> 6 & 1L) != 0L)) {
            curConditionStates = player.func_70093_af() ? (curConditionStates |= 0x20L) : (curConditionStates |= 0x40L);
        }
        if (player.field_70170_p.func_72820_D() - this.lastExtendedConditionCheck < 20L) {
            long States = this.conditionStates;
            States &= 0xFFFFFFFFFFFFFF7FL;
            States &= 0xFFFFFFFFFFFFFEFFL;
            States &= 0xFFFFFFFFFFFFFFDFL;
            return this.set(curConditionStates | (States &= 0xFFFFFFFFFFFFFFBFL));
        }
        this.lastExtendedConditionCheck = player.field_70170_p.func_72820_D();
        if (this.hasRainSensor && ((checkConditions >>> 1 & 1L) != 0L || (checkConditions >>> 2 & 1L) != 0L)) {
            curConditionStates = player.field_70170_p.func_72896_J() ? (curConditionStates |= 2L) : (curConditionStates |= 4L);
        }
        if (this.hasGeolyzer && ((checkConditions >>> 3 & 1L) != 0L || (checkConditions >>> 4 & 1L) != 0L)) {
            curConditionStates = utilsCommon.isPlayerSwimming((EntityPlayer)player) ? (curConditionStates |= 8L) : (curConditionStates |= 0x10L);
        }
        if (this.hasLightSensor) {
            int lightLevel = utilsCommon.getLightLevelPlayer((EntityPlayer)player);
            int i = 9;
            int l = 0;
            while (i < 24) {
                if ((checkConditions >>> i & 1L) != 0L && lightLevel >= l) {
                    curConditionStates |= 1L << i;
                }
                ++i;
                ++l;
            }
            i = 25;
            l = 0;
            while (i < 40) {
                if ((checkConditions >>> i & 1L) != 0L && lightLevel <= l) {
                    curConditionStates |= 1L << i;
                }
                ++i;
                ++l;
            }
        }
        return this.set(curConditionStates);
    }

    public void setOverlay(boolean state) {
        this.overlayActive = state;
    }

    public long get() {
        return this.conditionStates;
    }

    private long set(long newStates) {
        this.conditionStates = newStates;
        return this.get();
    }
}

