/*
 * Decompiled with CFR 0.152.
 */
package toast.lavaMonsters;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import toast.lavaMonsters.EntityAILavaMonsterAttack;
import toast.lavaMonsters.Properties;

public class EntityLavaMonster
extends EntityMob {
    public static final double MAX_HEALTH = Properties.getDouble("_general", "monster_health");
    public static final int BASE_ARMOR = Properties.getInt("_general", "monster_armor");
    public static final boolean ANIMATE_TEXTURE = Properties.getBoolean("_general", "animated_texture");
    public static final double SPAWN_CHANCE = Properties.getDouble("spawning", "spawn_chance");
    public int attackDelay = 0;
    private boolean textureInc = true;
    private byte textureTicks = 0;
    private byte textureIndex = 0;

    public EntityLavaMonster(World world) {
        super(world);
        this.func_70105_a(0.8f, 2.2f);
        this.field_70178_ae = true;
        this.field_70728_aV = 8;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILavaMonsterAttack(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)0);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + BASE_ARMOR);
    }

    public void func_70636_d() {
        int z;
        int y;
        int x;
        if (this.field_70170_p.field_72995_K) {
            this.updateTexture();
        } else {
            this.attackDelay = Math.max(0, this.attackDelay - 1);
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.field_70170_p.func_72869_a("lava", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + (double)this.field_70131_O / 2.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            this.field_70170_p.func_72956_a((Entity)this, "liquid.lavapop", 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.field_70170_p.func_72956_a((Entity)this, "liquid.lava", 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
        if (this.field_70170_p.func_147437_c(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 2);
        }
        if (this.func_70013_c(1.0f) > 0.5f) {
            this.field_70708_bq -= 2;
        }
        super.func_70636_d();
    }

    public void attackEntityWithFireball(EntityLivingBase target) {
        EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, target.field_70165_t - this.field_70165_t, target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - (double)(this.field_70131_O / 2.0f), target.field_70161_v - this.field_70161_v);
        fireball.field_70163_u = this.field_70163_u + (double)this.field_70131_O - 0.5;
        this.func_85030_a("mob.ghast.fireball", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource.func_76364_f() instanceof EntitySnowball) {
            damage = Math.max(3.0f, damage);
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected Item func_146068_u() {
        return Items.field_151059_bz;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151059_bz, 1);
        }
        if (recentlyHit && (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151044_h, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack drop = new ItemStack((Item)Items.field_151021_T);
        drop.func_151001_c("\u00a7cLava Boots");
        drop.func_77966_a(Enchantment.field_77329_d, 10);
        ((ItemArmor)drop.func_77973_b()).func_82813_b(drop, 0xFF0000);
        this.func_70099_a(drop, 0.0f);
    }

    public boolean func_70027_ad() {
        return this.field_70180_af.func_75683_a(31) == 1;
    }

    public void setBurningState(boolean state) {
        this.field_70180_af.func_75692_b(31, (Object)(state ? (byte)1 : 0));
    }

    public void updateTexture() {
        if (!ANIMATE_TEXTURE || (this.textureTicks = (byte)(this.textureTicks + 1)) < 2) {
            return;
        }
        this.textureTicks = 0;
        this.textureIndex = (byte)(this.textureIndex + (this.textureInc ? 1 : -1));
        if (this.textureIndex < 0) {
            this.textureIndex = 1;
            this.textureInc = true;
        } else if (this.textureIndex > 19) {
            this.textureIndex = (byte)18;
            this.textureInc = false;
        }
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextDouble() < SPAWN_CHANCE && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
    }

    protected String func_70621_aR() {
        return "mob.ghast.scream";
    }

    protected String func_70673_aS() {
        return "mob.ghast.death";
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int getEntityBrightnessForRender(float f) {
        return 0xF000F0;
    }

    public float getEntityBrightness(float f) {
        return 1.0f;
    }
}

