/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import extracells.gridblock.ECBaseGridBlock;
import extracells.models.PartModels;
import extracells.part.PartECBase;
import extracells.util.AEUtils;
import extracells.util.MachineSource;
import extracells.util.PermissionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class PartFluidPlaneAnnihilation
extends PartECBase
implements IGridTickable {
    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public void onNeighborChanged(IBlockAccess var1, BlockPos var2, BlockPos var3) {
        IAEFluidStack toInject;
        TileEntity hostTile = this.getHostTile();
        ECBaseGridBlock gridBlock = this.getGridBlock();
        if (hostTile == null || gridBlock == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        World world = hostTile.func_145831_w();
        BlockPos pos = hostTile.func_174877_v();
        EnumFacing facing = this.getFacing();
        BlockPos offsetPos = pos.func_177972_a(facing);
        IBlockState blockState = world.func_180495_p(offsetPos);
        Block fluidBlock = blockState.func_177230_c();
        int meta = fluidBlock.func_176201_c(blockState);
        if (fluidBlock instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)fluidBlock;
            FluidStack drained = block.drain(world, offsetPos, false);
            if (drained == null) {
                return;
            }
            IAEFluidStack toInject2 = AEUtils.createFluidStack(drained);
            IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)toInject2, Actionable.SIMULATE, (IActionSource)new MachineSource(this));
            if (notInjected != null) {
                return;
            }
            monitor.injectItems((IAEStack)toInject2, Actionable.MODULATE, (IActionSource)new MachineSource(this));
            block.drain(world, offsetPos, true);
        } else if (meta == 0 && (toInject = PartFluidPlaneAnnihilation.getFluidStack(fluidBlock)) != null) {
            IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)toInject, Actionable.SIMULATE, (IActionSource)new MachineSource(this));
            if (notInjected != null) {
                return;
            }
            monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (IActionSource)new MachineSource(this));
            world.func_175698_g(offsetPos);
        }
    }

    private static IAEFluidStack getFluidStack(Block fluidBlock) {
        return fluidBlock == Blocks.field_150355_j || fluidBlock == Blocks.field_150358_i ? AEUtils.createFluidStack(FluidRegistry.WATER) : (fluidBlock == Blocks.field_150353_l || fluidBlock == Blocks.field_150356_k ? AEUtils.createFluidStack(FluidRegistry.LAVA) : null);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.ANNIHILATION_PLANE_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.ANNIHILATION_PLANE_ON;
        }
        return PartModels.ANNIHILATION_PLANE_OFF;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelChanged e) {
        if (e.node == this.getGridNode()) {
            this.onNeighborChanged();
        }
    }

    @Override
    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange notUsed) {
        super.setPower(notUsed);
        this.onNeighborChanged();
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        this.onNeighborChanged();
        return TickRateModulation.SAME;
    }
}

