## Keypad

![](https://i.imgur.com/x6wn7yV.png)

A Keypad with buttons you can press to raise events to attached computers

### Methods
```lua
keypad = component.os_keypad
keypad.setEventName("eventName") -- Sets the event name returned when you press a button, default is keypad
keypad.setDisplay("displayText", optional int:textColor) -- textColor is a minecraft color code
    
-- Custom button labels and colors

-- This is the default order, change any of them to change the button label in that place.
customButtons = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"} 

-- This works the same as button labels, but it takes a color code to color the button label in that position.
customButtonColor = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1} 

keypad.setKey(customButtons, customButtonColor)
```

### Events
    
```lua
event = require("event")
eventName, address, button, button_label = event.pull("keypad")
print("key pressed: " .. button)
```
Button is the button id, button_label is the current button label.