### 2D Overlay Widget
## OBJModel2D
```lua
widget = component.glasses.addOBJModel2D()
-- adds a Wavefront Object Model to the 2D Overlay
```
```lua
widget.loadObj(String:waveFrontObjectData)
-- loads the model from the parsed object data
```

### Examples
```lua
-- load an object file to a local variable (objData)
local fh = io.open("/home/someWaveFrontObjectFile.obj", "r")
local objData = fh:read("*a")
fh:close()

glasses = require("component").glasses
widget = glasses.addOBJModel2D()

-- loads the data from the obj file to the widget
widget.loadOBJ(objData)
```


### methods
* [default](Widget_Methods_default)
  * [getID](Widget_Methods_default#getID)
  * [removeWidget](Widget_Methods_default#removeWidget)
* [private](Widget_Methods_private)
  * [getOwner](Widget_Methods_private#getOwner)
  * [getOwnerUUID](Widget_Methods_private#getOwnerUUID)
  * [setOwner](Widget_Methods_private#setOwner)
* [alignment](Widget_Methods_alignments)
  * [setVerticalAlign](Widget_Methods_alignments#setVerticalAlign)
  * [setHorizontalAlign](Widget_Methods_alignments#setHorizontalAlign)
* [visibility](Widget_Methods_visibility)
  * [isVisible](Widget_Methods_visibility#isVisible)
  * [setVisible](Widget_Methods_visibility#setVisible)
  
* [Modifier Methods](WidgetModifiers)
  * [addColor](WidgetModifiers#addColor)
  * [addRotation](WidgetModifiers#addRotation)
  * [addScale](WidgetModifiers#addScale)
  * [addTranslation](WidgetModifiers#addTranslation)
  * [getModifiers](WidgetModifierMethods#getModifiers)
  * [removeModifier](WidgetModifierMethods#removeModifier)
  * [setCondition](WidgetModifierConditions)
* [Modifier Animation](WidgetModifiers#animation)
  * [setEasing](WidgetModifiers#seteasing)
  * [removeEasing](WidgetModifiers#removeeasing)