/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.RecipeSearchField;
import codechicken.nei.RestartableTask;
import codechicken.nei.SearchField;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabs;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.SearchRecipeHandler;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe<H extends IRecipeHandler>
extends GuiContainer
implements IGuiContainerOverlay,
IGuiClientSide,
IGuiHandleMouseWheel,
IContainerTooltipHandler,
INEIGuiHandler {
    private static final int BG_TOP_HEIGHT = 6;
    private static final int BG_MIDDLE_HEIGHT = 154;
    private static final int BG_BOTTOM_HEIGHT = 6;
    private static final int BG_TOP_Y = 0;
    private static final int BG_MIDDLE_Y = 6;
    private static final int BG_BOTTOM_Y = 160;
    private static final int borderPadding = 6;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 12;
    public static final List<IRecipeFilter.IRecipeFilterProvider> recipeFilterers = new LinkedList<IRecipeFilter.IRecipeFilterProvider>();
    protected boolean limitToOneRecipe = false;
    protected PermutationTooltipLineHandler permutationTooltipLineHandler;
    final DrawableResource bgTop = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 6).build();
    final DrawableResource bgMiddle = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 6, 176, 154).build();
    final DrawableResource bgBottom = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 160, 176, 6).build();
    public ArrayList<H> currenthandlers = new ArrayList();
    public int page;
    public int recipetype;
    public BookmarkRecipeId recipeId;
    public ContainerRecipe slotcontainer;
    public GuiContainer firstGui;
    public GuiScreen firstGuiGeneral;
    public GuiScreen prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    private GuiButton nexttype;
    private GuiButton prevtype;
    private GuiOverlayButton[] overlayButtons = new GuiOverlayButton[0];
    private final Rectangle area = new Rectangle();
    private final GuiRecipeTabs recipeTabs = new GuiRecipeTabs(this);
    private final GuiRecipeCatalyst guiRecipeCatalyst = new GuiRecipeCatalyst(this);
    private SearchRecipeHandler<H> handler;
    private HandlerInfo handlerInfo;
    private int yShift = 0;
    protected static final RestartableTask updateFilter = new RestartableTask("NEI Recipe Filtering"){

        @Override
        public void execute() {
            GuiRecipe guiRecipe;
            SearchRecipeHandler searchHandler;
            GuiScreen currentScreen = NEIClientUtils.mc().field_71462_r;
            if (currentScreen instanceof GuiRecipe && (searchHandler = (guiRecipe = (GuiRecipe)currentScreen).handler) != null && searchHandler.searchingAvailable()) {
                if (searchField.text().isEmpty()) {
                    searchHandler.setSearchIndices(null);
                    guiRecipe.changePage(0);
                } else {
                    ItemRecipeFilter filter = new ItemRecipeFilter(searchField.getFilter());
                    List<Integer> filtered = searchHandler.getSearchResult(filter);
                    if (filtered == null) {
                        this.stop();
                    }
                    if (this.interrupted()) {
                        return;
                    }
                    searchHandler.setSearchIndices(filtered);
                    guiRecipe.changePage(0);
                }
            }
        }
    };
    protected static final RecipeSearchField searchField = new RecipeSearchField(""){

        @Override
        protected boolean noResults() {
            GuiScreen currentScreen = NEIClientUtils.mc().field_71462_r;
            return !(currentScreen instanceof GuiRecipe) || ((GuiRecipe)currentScreen).numRecipes() > 0;
        }

        @Override
        public void onTextChange(String oldText) {
            updateFilter.restart();
        }
    };
    protected static final Button toggleSearch = new Button(){

        @Override
        public boolean onButtonPress(boolean rightclick) {
            if (rightclick) {
                return false;
            }
            if (searchField.isVisible()) {
                searchField.setText("");
                searchField.setFocus(false);
                searchField.setVisible(false);
                this.state = 0;
            } else {
                searchField.setVisible(true);
                searchField.setFocus(true);
                this.state = 2;
            }
            return true;
        }
    };
    private boolean isHeightHackApplied = false;

    protected GuiRecipe(GuiScreen prevgui) {
        super((Container)new ContainerRecipe());
        this.slotcontainer = (ContainerRecipe)this.field_147002_h;
        this.prevGui = prevgui;
        this.firstGuiGeneral = prevgui;
        if (prevgui instanceof GuiContainer) {
            this.firstGui = (GuiContainer)prevgui;
        }
        if (prevgui instanceof IGuiContainerOverlay) {
            this.firstGui = ((IGuiContainerOverlay)prevgui).getFirstScreen();
            this.firstGuiGeneral = ((IGuiContainerOverlay)prevgui).getFirstScreenGeneral();
        }
    }

    public void limitToOneRecipe() {
        this.limitToOneRecipe = true;
    }

    public boolean isLimitedToOneRecipe() {
        return this.limitToOneRecipe;
    }

    public void func_73866_w_() {
        this.field_146999_f = 176;
        this.field_147000_g = Math.min(Math.max(this.field_146295_m - 68, 166), 370);
        if (!this.limitToOneRecipe) {
            super.func_73866_w_();
        } else {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.field_147000_g = this.getWidgetSize().height;
            this.field_146297_k = NEIClientUtils.mc();
            this.field_146289_q = this.field_146297_k.field_71466_p;
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
            this.field_146294_l = scaledresolution.func_78326_a();
            this.field_146295_m = scaledresolution.func_78328_b();
        }
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2 + 10;
        if (this.handler == null) {
            this.setRecipePage(this.recipetype);
        } else {
            this.updateOverlayButtons();
        }
        this.checkYShift();
        int rightButtonX = this.field_147003_i + this.field_146999_f - 6 - 13;
        int leftButtonX = this.field_147003_i + 6;
        this.nexttype = new GuiNEIButton(0, leftButtonX, this.field_147009_r + 3, 13, 12, "<"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.prevType();
            }
        };
        this.prevtype = new GuiNEIButton(1, rightButtonX, this.field_147009_r + 3, 13, 12, ">"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.nextType();
            }
        };
        this.nextpage = new GuiNEIButton(2, leftButtonX, this.field_147009_r + 17, 13, 12, "<"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.prevPage();
            }
        };
        this.prevpage = new GuiNEIButton(3, rightButtonX, this.field_147009_r + 17, 13, 12, ">"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.nextPage();
            }
        };
        GuiRecipe.toggleSearch.icon = new DrawableBuilder("nei:textures/nei_sprites.png", 0, 76, 10, 10).build();
        this.field_146292_n.addAll(Arrays.asList(this.nexttype, this.prevtype, this.nextpage, this.prevpage));
        this.overlayButtons = new GuiOverlayButton[0];
        if (this.currenthandlers.size() == 1) {
            this.nexttype.field_146125_m = false;
            this.prevtype.field_146125_m = false;
        }
        this.recipeTabs.initLayout();
        this.refreshPage();
    }

    private void updateOverlayButtons() {
        List<Integer> indices = this.getRecipeIndices();
        if (this.isDirtyOverlayButtons(indices)) {
            this.field_146292_n.removeIf(Arrays.asList(this.overlayButtons)::contains);
            int xOffset = (this.limitToOneRecipe ? 0 : this.field_147003_i) + this.field_146999_f - 6;
            int yOffset = (this.limitToOneRecipe ? -12 : this.field_147009_r - 18) + this.getRecipePosition((int)0).y;
            int height = this.handlerInfo.getHeight() - this.yShift;
            GuiOverlayButton.UpdateOverlayButtonsEvent.Pre preEvent = new GuiOverlayButton.UpdateOverlayButtonsEvent.Pre(this, xOffset, yOffset, height, this.handlerInfo);
            List<GuiOverlayButton> buttons = new ArrayList();
            if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                buttons = preEvent.buttonList;
            } else {
                for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                    int recipeIndex = indices.get(refIndex);
                    if (this.handler.original.getResultStack(recipeIndex) == null && this.handler.original.getOtherStacks(recipeIndex).isEmpty()) continue;
                    buttons.add(new GuiOverlayButton(this.firstGui, (IRecipeHandler)this.handler.original, recipeIndex, xOffset - 13, yOffset + height * (refIndex + 1), 13, 12));
                }
                if (this.equals(this.field_146297_k.field_71462_r)) {
                    GuiOverlayButton.UpdateOverlayButtonsEvent.Post postEvent = new GuiOverlayButton.UpdateOverlayButtonsEvent.Post(this, buttons);
                    MinecraftForge.EVENT_BUS.post((Event)postEvent);
                    buttons = postEvent.buttonList;
                }
            }
            this.overlayButtons = buttons.toArray(new GuiOverlayButton[buttons.size()]);
            this.field_146292_n.addAll(buttons);
        }
    }

    private boolean isDirtyOverlayButtons(List<Integer> indices) {
        if (this.overlayButtons.length == 0) {
            return true;
        }
        for (GuiOverlayButton button : this.overlayButtons) {
            if (button.handler == this.handler.original && indices.contains(button.recipeIndex)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRecipeFilter getRecipeListFilter() {
        if (recipeFilterers.isEmpty()) {
            return null;
        }
        AllMultiRecipeFilter recipeFilter = new AllMultiRecipeFilter();
        List<IRecipeFilter.IRecipeFilterProvider> list = recipeFilterers;
        synchronized (list) {
            for (IRecipeFilter.IRecipeFilterProvider p : recipeFilterers) {
                IRecipeFilter filter = p.getFilter();
                if (filter == null) continue;
                recipeFilter.filters.add(filter);
            }
        }
        return recipeFilter.filters.size() == 1 ? recipeFilter.filters.get(0) : recipeFilter;
    }

    public static ItemFilter getSearchItemFilter() {
        return searchField.getFilter();
    }

    private void checkYShift() {
        this.yShift = this.handlerInfo == null ? 0 : this.handlerInfo.getYShift();
    }

    public void setRecipePage(int idx) {
        this.setRecipePage(idx, 0);
    }

    public void setRecipePage(int idx, int refIndex) {
        this.recipetype = (this.currenthandlers.size() + idx) % this.currenthandlers.size();
        this.handler = new SearchRecipeHandler<IRecipeHandler>((IRecipeHandler)this.currenthandlers.get(this.recipetype));
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler.original);
        if (!this.limitToOneRecipe) {
            searchField.setText("");
            searchField.setVisible(false);
            GuiRecipe.toggleSearch.state = 0;
        }
        this.page = Math.min(Math.max(0, refIndex), this.numRecipes() - 1) / this.getRecipesPerPage();
        this.changePage(0);
        this.recipeTabs.calcPageNumber();
        this.checkYShift();
    }

    public List<GuiButton> getOverlayButtons() {
        return Collections.unmodifiableList(Arrays.asList(this.overlayButtons));
    }

    public int openTargetRecipe(BookmarkRecipeId recipeId) {
        int refIndex = -1;
        int recipetype = 0;
        this.recipeId = recipeId;
        if (this.recipeId != null) {
            for (int j = 0; j < this.currenthandlers.size(); ++j) {
                IRecipeHandler localHandler = (IRecipeHandler)this.currenthandlers.get(j);
                HandlerInfo localHandlerInfo = GuiRecipeTab.getHandlerInfo(localHandler);
                if (!localHandlerInfo.getHandlerName().equals(this.recipeId.handlerName)) continue;
                recipetype = j;
                if (this.recipeId.ingredients.isEmpty()) break;
                refIndex = SearchRecipeHandler.findFirst(localHandler, recipeIndex -> this.recipeId.equalsIngredients(localHandler.getIngredientStacks(recipeIndex)));
                break;
            }
        }
        this.setRecipePage(recipetype, Math.max(0, refIndex));
        return refIndex;
    }

    public List<PositionedStack> getFocusedRecipeIngredients() {
        List<Integer> indices = this.getRecipeIndices();
        for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
            int recipeIndex = indices.get(refIndex);
            if (!this.recipeInFocus(refIndex, recipeIndex)) continue;
            return this.handler.original.getIngredientStacks(recipeIndex);
        }
        return null;
    }

    public int prepareFocusedRecipeResultStackSize(ItemStack stackover) {
        List<Integer> indices = this.getRecipeIndices();
        for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
            int recipeIndex = indices.get(refIndex);
            if (!this.recipeInFocus(refIndex, recipeIndex)) continue;
            PositionedStack result = this.handler.original.getResultStack(recipeIndex);
            int stackSize = 0;
            if (result != null && StackInfo.equalItemAndNBT(result.item, stackover, true)) {
                stackSize += result.item.field_77994_a;
            }
            List<PositionedStack> stacks = this.handler.original.getOtherStacks(recipeIndex);
            for (PositionedStack pStack : stacks) {
                if (!StackInfo.equalItemAndNBT(pStack.item, stackover, true)) continue;
                stackSize += pStack.item.field_77994_a;
            }
            return stackSize;
        }
        return stackover.field_77994_a;
    }

    protected boolean recipeInFocus(int refIndex, int recipeIndex) {
        PositionedStack result = this.handler.original.getResultStack(recipeIndex);
        if (result != null && this.isMouseOver(result, refIndex)) {
            return true;
        }
        List<PositionedStack> stacks = this.handler.original.getOtherStacks(recipeIndex);
        for (PositionedStack stack : stacks) {
            if (!this.isMouseOver(stack, refIndex)) continue;
            return true;
        }
        return false;
    }

    public String getHandlerName() {
        return this.handlerInfo.getHandlerName();
    }

    public H getHandler() {
        return this.handler.original;
    }

    public List<Integer> getRecipeIndices() {
        int recipesPerPage = this.getRecipesPerPage();
        int minIndex = this.page * recipesPerPage;
        int maxIndex = Math.min(this.numRecipes(), (this.page + 1) * recipesPerPage);
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int index = minIndex; index < maxIndex; ++index) {
            range.add(this.handler.ref(index));
        }
        return range;
    }

    private int numRecipes() {
        return this.handler == null ? 0 : this.handler.numRecipes();
    }

    public void func_73869_a(char c, int i) {
        if (searchField.isVisible() && searchField.focused() && searchField.handleKeyPress(i, c)) {
            return;
        }
        if (i == 1) {
            this.field_146297_k.func_147108_a(this.firstGuiGeneral);
            NEICPH.sendRequestContainer();
            return;
        }
        if (searchField.isVisible() && searchField.focused()) {
            searchField.lastKeyTyped(i, c);
            return;
        }
        if (GuiContainerManager.getManager(this).lastKeyTyped(i, c)) {
            return;
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                if (!this.handler.original.keyTyped(this, c, i, recipeIndex)) continue;
                return;
            }
            Point mouse = GuiDraw.getMousePosition();
            for (GuiOverlayButton button : this.overlayButtons) {
                if (!button.contains(mouse.x, mouse.y)) continue;
                button.lastKeyTyped(this, c, i);
            }
        }
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(this.firstGuiGeneral);
            NEICPH.sendRequestContainer();
        } else if (NEIClientConfig.isKeyHashDown("gui.back")) {
            this.field_146297_k.func_147108_a(this.prevGui);
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_machine")) {
            this.prevType();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_machine")) {
            this.nextType();
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_recipe")) {
            this.prevPage();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_recipe")) {
            this.nextPage();
        }
    }

    protected void func_73864_a(int mousex, int mousey, int button) {
        if (!this.limitToOneRecipe && this.handler != null && this.handler.searchingAvailable()) {
            if (toggleSearch.contains(mousex - this.field_147003_i, mousey - this.field_147009_r)) {
                toggleSearch.handleClick(mousex - this.field_147003_i, mousey - this.field_147009_r, button);
            } else if (searchField.contains(mousex - this.field_147003_i, mousey - this.field_147009_r)) {
                searchField.handleClick(mousex - this.field_147003_i, mousey - this.field_147009_r, button);
            } else {
                searchField.onGuiClick(mousex - this.field_147003_i, mousey - this.field_147009_r);
            }
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                if (!this.handler.original.mouseClicked(this, button, recipeIndex)) continue;
                return;
            }
        }
        if (this.recipeTabs.mouseClicked(mousex, mousey, button)) {
            return;
        }
        super.func_73864_a(mousex, mousey, button);
    }

    @Override
    public void mouseScrolled(int scroll) {
        if (this.recipeTabs.mouseScrolled(scroll)) {
            return;
        }
        for (int recipeIndex : this.getRecipeIndices()) {
            if (!this.handler.original.mouseScrolled(this, scroll, recipeIndex)) continue;
            return;
        }
        if (NEIClientUtils.shiftKey()) {
            if (scroll < 0) {
                this.nextType();
            } else {
                this.prevType();
            }
            return;
        }
        if (new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g).contains(GuiDraw.getMousePosition())) {
            if (scroll > 0) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.handler.original.onUpdate();
        this.refreshPage();
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        String s;
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            GuiOverlayButton[] guiOverlayButtonArray = this.getRecipeIndices().iterator();
            while (guiOverlayButtonArray.hasNext()) {
                int recipeIndex = guiOverlayButtonArray.next();
                currenttip = this.handler.original.handleTooltip(this, currenttip, recipeIndex);
            }
            for (GuiOverlayButton button : this.overlayButtons) {
                if (!button.contains(mousex, mousey)) continue;
                currenttip = button.handleTooltip(this, currenttip);
            }
        }
        this.recipeTabs.handleTooltip(mousex, mousey, currenttip);
        if (currenttip.isEmpty() && searchField.isVisible() && new Rectangle(GuiRecipe.searchField.x + GuiRecipe.searchField.w, 15, 44, 16).contains(mousex - this.field_147003_i, mousey - this.field_147009_r) && this.field_146289_q.func_78256_a(s = String.format("%d/%d", this.page + 1, (this.numRecipes() - 1) / this.getRecipesPerPage() + 1)) >= 45) {
            currenttip.add(s);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        List<Integer> indices = this.getRecipeIndices();
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : indices) {
                currenttip = this.handler.original.handleItemTooltip(this, itemstack, currenttip, recipeIndex);
            }
        }
        if (NEIClientConfig.showCycledIngredientsTooltip()) {
            PositionedStack focused = null;
            block6: for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                int recipeIndex;
                recipeIndex = indices.get(refIndex);
                if (itemstack == null || focused != null) continue;
                List<PositionedStack> stacks = this.handler.original.getIngredientStacks(recipeIndex);
                for (PositionedStack pStack : stacks) {
                    if (!this.isMouseOver(pStack, refIndex)) continue;
                    focused = pStack;
                    continue block6;
                }
            }
            if (focused == null || focused.items.length <= 1) {
                this.permutationTooltipLineHandler = null;
            } else if (this.permutationTooltipLineHandler == null || this.permutationTooltipLineHandler.pStack != focused) {
                this.permutationTooltipLineHandler = PermutationTooltipLineHandler.getInstance(focused);
            }
        } else if (this.permutationTooltipLineHandler != null) {
            this.permutationTooltipLineHandler = null;
        }
        if (this.permutationTooltipLineHandler != null) {
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.permutationTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (GuiOverlayButton button : this.overlayButtons) {
                if (!button.contains(mousex, mousey)) continue;
                hotkeys = button.handleHotkeys(gui, mousex, mousey, hotkeys);
            }
        }
        return hotkeys;
    }

    @Override
    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    private void nextPage() {
        this.changePage(1);
    }

    private void prevPage() {
        this.changePage(-1);
    }

    protected void nextType() {
        this.setRecipePage(++this.recipetype);
    }

    protected void prevType() {
        this.setRecipePage(--this.recipetype);
    }

    protected void overlayRecipe(int recipeIndex, boolean shift) {
        if (this.handler == null || !this.handler.original.hasOverlay(this.firstGui, this.firstGui.field_147002_h, recipeIndex)) {
            return;
        }
        boolean requireShiftForOverlayRecipe = NEIClientConfig.requireShiftForOverlayRecipe();
        IOverlayHandler overlayHandler = this.handler.original.getOverlayHandler(this.firstGui, recipeIndex);
        IRecipeOverlayRenderer renderer = this.handler.original.getOverlayRenderer(this.firstGui, recipeIndex);
        if (renderer == null || !requireShiftForOverlayRecipe || shift) {
            if (overlayHandler != null) {
                overlayHandler.overlayRecipe(this.firstGui, (IRecipeHandler)this.handler.original, recipeIndex, !requireShiftForOverlayRecipe || shift);
            }
        } else {
            LayoutManager.overlayRenderer = renderer;
        }
    }

    protected void changePage(int shift) {
        int recipesPerPage = this.getRecipesPerPage();
        int numRecipes = this.numRecipes();
        if (numRecipes > 0) {
            int numPages = (int)Math.ceil((float)numRecipes / (float)recipesPerPage);
            this.page = Math.min(Math.max(0, this.page), numPages);
            this.page = (numPages + this.page + shift) % numPages;
        } else {
            this.page = 0;
        }
    }

    public void refreshPage() {
        this.changePage(0);
        this.refreshSlots();
        int recipesPerPage = this.getRecipesPerPage();
        boolean multiplepages = this.numRecipes() > recipesPerPage;
        int numRecipes = Math.min(this.numRecipes() - this.page * recipesPerPage, recipesPerPage);
        this.area.width = this.handlerInfo.getWidth();
        this.area.height = this.handlerInfo.getHeight() * numRecipes;
        this.area.x = this.field_147003_i - 2;
        this.area.y = this.field_147009_r - 4 + this.yShift;
        this.checkYShift();
        if (!this.limitToOneRecipe) {
            RecipeCatalysts.updatePosition(this.field_147000_g - 6 - 12);
            GuiRecipe.toggleSearch.h = 12;
            GuiRecipe.toggleSearch.w = 12;
            GuiRecipe.toggleSearch.x = 19;
            GuiRecipe.toggleSearch.y = 17;
            GuiRecipe.searchField.y = 16;
            GuiRecipe.searchField.x = 19 + GuiRecipe.toggleSearch.w - 1;
            GuiRecipe.searchField.w = this.field_146999_f - 38 + 1 - GuiRecipe.toggleSearch.w - 45;
            GuiRecipe.searchField.h = 14;
        }
        this.nextpage.field_146124_l = this.prevpage.field_146124_l = multiplepages;
        this.updateOverlayButtons();
        this.recipeTabs.refreshPage();
    }

    private void refreshSlots() {
        this.slotcontainer.field_75151_b.clear();
        List<Integer> indices = this.getRecipeIndices();
        for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
            int recipeIndex = indices.get(refIndex);
            Point p = this.getRecipePosition(refIndex);
            if (this.isHeightHackApplied) {
                p.translate(0, 16);
            }
            TemplateRecipeHandler.disableCycledIngredients = false;
            List<PositionedStack> stacks = this.handler.original.getIngredientStacks(recipeIndex);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            stacks = this.handler.original.getOtherStacks(recipeIndex);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            PositionedStack result = this.handler.original.getResultStack(recipeIndex);
            if (result != null) {
                this.slotcontainer.addSlot(result, p.x, p.y);
            }
            if (!this.limitToOneRecipe) {
                List<PositionedStack> catalysts = RecipeCatalysts.getRecipeCatalysts(this.handler.original);
                for (PositionedStack catalyst : catalysts) {
                    int xOffset = -15;
                    int yOffset = 6;
                    this.slotcontainer.addSlot(catalyst, xOffset, yOffset);
                }
            }
            TemplateRecipeHandler.disableCycledIngredients = true;
        }
    }

    public void func_146979_b(int mouseX, int mouseY) {
        int ySkip;
        GuiContainerManager.enable2DRender();
        int recipesPerPage = this.getRecipesPerPage();
        int n = ySkip = this.limitToOneRecipe ? 7 : 32;
        if (!this.limitToOneRecipe) {
            String s = this.handler.original.getRecipeName().trim();
            this.field_146289_q.func_78261_a(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, 5, 0xFFFFFF);
            if (this.handler.searchingAvailable()) {
                toggleSearch.draw(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            if (searchField.isVisible()) {
                searchField.draw(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                s = NEIClientUtils.cropText(this.field_146289_q, String.format("%d/%d", this.page + 1, (this.numRecipes() - 1) / recipesPerPage + 1), 45);
                this.field_146289_q.func_78261_a(s, GuiRecipe.searchField.x + GuiRecipe.searchField.w + (44 - this.field_146289_q.func_78256_a(s)) / 2, 19, 0xFFFFFF);
            } else {
                s = NEIClientUtils.translate("recipe.page", this.page + 1, (this.numRecipes() - 1) / recipesPerPage + 1);
                this.field_146289_q.func_78261_a(s, (this.field_146999_f - this.field_146289_q.func_78256_a(s)) / 2, 19, 0xFFFFFF);
            }
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            List<Integer> indices = this.getRecipeIndices();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)5.0f, (float)(ySkip + this.yShift), (float)0.0f);
            for (int refIndex = 0; refIndex < indices.size(); ++refIndex) {
                GuiOverlayButton overlayButton;
                int recipeIndex = indices.get(refIndex);
                this.handler.original.drawForeground(recipeIndex);
                if (this.limitToOneRecipe && (overlayButton = (GuiOverlayButton)Arrays.asList(this.overlayButtons).stream().filter(b -> b.recipeIndex == recipeIndex).findAny().orElse(null)) != null && overlayButton.field_146124_l) {
                    String overlayKeyName = NEIClientConfig.getKeyName("gui.overlay_use");
                    if (overlayKeyName != null) {
                        this.field_146289_q.func_78261_a(EnumChatFormatting.ITALIC + overlayKeyName, this.field_146999_f - 6 - this.field_146289_q.func_78256_a(overlayKeyName) - 10, this.handlerInfo.getHeight() - this.field_146289_q.field_78288_b, 0xFFFFFF);
                    }
                    overlayButton.drawItemPresenceOverlay();
                }
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)5.0f, (float)(ySkip + this.yShift), (float)0.0f);
            if (!this.limitToOneRecipe && NEIClientConfig.itemPresenceOverlay() > 0) {
                for (GuiOverlayButton button : this.overlayButtons) {
                    if (!button.contains(mouseX, mouseY)) continue;
                    GL11.glTranslatef((float)0.0f, (float)(this.handlerInfo.getHeight() * indices.indexOf(button.recipeIndex)), (float)0.0f);
                    button.drawItemPresenceOverlay();
                    break;
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void func_146976_a(float f, int mouseX, int mouseY) {
        int ySkip = this.limitToOneRecipe ? 7 : 32;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundTiled(this.field_147003_i, this.field_147009_r);
        if (NEIClientConfig.areJEIStyleTabsVisible() && !this.limitToOneRecipe) {
            GuiRecipe.func_73734_a((int)(this.field_147003_i + 6 + 13 - 1), (int)this.nexttype.field_146129_i, (int)(this.field_147003_i + this.field_146999_f - 6 - 13), (int)(this.nexttype.field_146129_i + 12), (int)0x30000000);
            GuiRecipe.func_73734_a((int)(this.field_147003_i + 6 + 13 - 1), (int)this.nextpage.field_146129_i, (int)(this.field_147003_i + this.field_146999_f - 6 - 13), (int)(this.nextpage.field_146129_i + 12), (int)0x30000000);
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.recipeTabs.draw(mouseX, mouseY);
            if (NEIClientConfig.areJEIStyleRecipeCatalystsVisible()) {
                this.guiRecipeCatalyst.draw();
            }
            RenderHelper.func_74518_a();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_147003_i + 5), (float)(this.field_147009_r + ySkip + this.yShift), (float)0.0f);
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            for (int recipeIndex : this.getRecipeIndices()) {
                this.handler.original.drawBackground(recipeIndex);
                GL11.glTranslatef((float)0.0f, (float)this.handlerInfo.getHeight(), (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawBackgroundTiled(int j, int k) {
        int handlerHeight = this.getWidgetSize().height;
        this.bgTop.draw(j, k + 0);
        int tiledHeight = handlerHeight - 6 - 6;
        if (tiledHeight > 0) {
            int yTileCount = tiledHeight / 154;
            int yRemainder = tiledHeight - yTileCount * 154;
            int yStart = k + 6 + tiledHeight;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileHeight = yTile == yTileCount ? yRemainder : 154;
                int y = yStart - (yTile + 1) * 154;
                if (tileHeight <= 0) continue;
                this.bgMiddle.draw(j, y, 154 - tileHeight, 0, 0, 0);
            }
        }
        this.bgBottom.draw(j, k + handlerHeight - 6);
    }

    public Dimension getWidgetSize() {
        if (this.handlerInfo == null) {
            return new Dimension(this.field_146999_f, this.field_147000_g);
        }
        int handlerHeight = this.limitToOneRecipe ? this.handlerInfo.getHeight() + this.yShift + 6 + 6 : this.field_147000_g;
        return new Dimension(this.field_146999_f, handlerHeight);
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    @Override
    public GuiScreen getFirstScreenGeneral() {
        return this.firstGuiGeneral;
    }

    public boolean isMouseOver(PositionedStack stack, int refIndex) {
        Slot mouseoverSlot;
        Point p = this.getRecipePosition(refIndex);
        Point mousepos = GuiDraw.getMousePosition();
        Slot stackSlot = this.slotcontainer.getSlotWithStack(stack, p.x, p.y);
        return stackSlot == (mouseoverSlot = this.func_146975_c(mousepos.x, mousepos.y));
    }

    private int getRecipesPerPage() {
        return this.limitToOneRecipe ? 1 : this.getRecipesPerPage(this.handlerInfo);
    }

    private int getRecipesPerPage(HandlerInfo handlerInfo) {
        if (handlerInfo != null) {
            return Math.max(Math.min((this.field_147000_g - 36) / handlerInfo.getHeight(), handlerInfo.getMaxRecipesPerPage()), 1);
        }
        if (this.handler != null) {
            return this.handler.original.recipiesPerPage();
        }
        return 1;
    }

    public Point getRecipePosition(int refIndex) {
        return new Point(5, (this.isHeightHackApplied ? 16 : 32) - (this.limitToOneRecipe ? 25 : 0) + this.yShift + refIndex % this.getRecipesPerPage() * this.handlerInfo.getHeight());
    }

    public abstract ArrayList<H> getCurrentRecipeHandlers();

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    @Override
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Override
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (searchField.isVisible() && searchField.contains(mousex - this.field_147003_i, mousey - this.field_147009_r)) {
            searchField.setText(SearchField.getEscapedSearchText(draggedStack));
            return true;
        }
        return false;
    }

    @Override
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return this.area.intersects(x, y, w, h);
    }

    protected static BookmarkRecipeId getCurrentRecipeId(GuiScreen gui) {
        if (gui instanceof GuiRecipe && ((GuiRecipe)gui).handler.numRecipes() > 0) {
            GuiRecipe gRecipe = (GuiRecipe)gui;
            List<Integer> indices = gRecipe.getRecipeIndices();
            int curRecipe = indices.isEmpty() ? 0 : indices.get(0);
            return new BookmarkRecipeId(gRecipe.handlerInfo.getHandlerName(), gRecipe.handler.original.getIngredientStacks(curRecipe));
        }
        return null;
    }

    public static class AllMultiRecipeFilter
    implements IRecipeFilter {
        public List<IRecipeFilter> filters;

        public AllMultiRecipeFilter(List<IRecipeFilter> filters) {
            this.filters = filters;
        }

        public AllMultiRecipeFilter(IRecipeFilter filters) {
            this(Arrays.asList(filters));
        }

        public AllMultiRecipeFilter() {
            this(new ArrayList<IRecipeFilter>());
        }

        @Override
        public boolean matches(IRecipeHandler handler, List<PositionedStack> ingredients, PositionedStack result, List<PositionedStack> others) {
            for (IRecipeFilter filter : this.filters) {
                try {
                    if (filter == null || filter.matches(handler, ingredients, result, others)) continue;
                    return false;
                }
                catch (Exception e) {
                    NEIClientConfig.logger.error("Exception filtering " + handler + " with " + filter, (Throwable)e);
                }
            }
            return true;
        }
    }

    private class CompatibilityHacks
    implements AutoCloseable {
        private final int trueHeight;
        private final int trueGuiTop;
        private final GuiScreen trueGui;

        private CompatibilityHacks() {
            this.trueHeight = GuiRecipe.this.field_146295_m;
            this.trueGuiTop = GuiRecipe.this.field_147009_r;
            GuiRecipe.this.isHeightHackApplied = NEIClientConfig.heightHackHandlerRegex.stream().map(pattern -> pattern.matcher(((GuiRecipe)GuiRecipe.this).handler.original.getHandlerId())).anyMatch(Matcher::matches);
            if (GuiRecipe.this.isHeightHackApplied) {
                GuiRecipe.this.field_147009_r += 16;
                GuiRecipe.this.field_146295_m = 2 * GuiRecipe.this.field_147009_r + 166;
            }
            this.trueGui = NEIClientUtils.mc().field_71462_r;
            if (GuiRecipe.this.limitToOneRecipe) {
                NEIClientUtils.mc().field_71462_r = GuiRecipe.this;
            }
        }

        @Override
        public void close() {
            GuiRecipe.this.field_147009_r = this.trueGuiTop;
            GuiRecipe.this.field_146295_m = this.trueHeight;
            if (GuiRecipe.this.limitToOneRecipe && NEIClientUtils.mc().field_71462_r == GuiRecipe.this) {
                NEIClientUtils.mc().field_71462_r = this.trueGui;
            }
            GuiRecipe.this.isHeightHackApplied = false;
        }
    }

    protected static class PermutationTooltipLineHandler
    extends ItemsTooltipLineHandler {
        protected PositionedStack pStack = null;

        public PermutationTooltipLineHandler(PositionedStack pStack, List<ItemStack> items) {
            super(NEIClientUtils.translate("recipe.accepts", new Object[0]), items, false, 5);
            this.pStack = pStack;
        }

        public static PermutationTooltipLineHandler getInstance(PositionedStack pStack) {
            List<ItemStack> items = pStack.getFilteredPermutations();
            if (items.size() > 1) {
                return new PermutationTooltipLineHandler(pStack, items);
            }
            return null;
        }

        @Override
        protected void drawItem(int x, int y, ItemStack drawStack, String stackSize) {
            if (StackInfo.equalItemAndNBT(drawStack, this.pStack.item, true)) {
                GL11.glPushAttrib((int)1048575);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GuiDraw.drawRect((int)(x - 1), (int)(y - 1), (int)18, (int)18, (int)0x66555555);
                GL11.glPopAttrib();
            }
            super.drawItem(x, y, drawStack, stackSize);
        }
    }

    public static class ItemRecipeFilter
    implements IRecipeFilter {
        public ItemFilter filter;

        public ItemRecipeFilter(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(IRecipeHandler handler, List<PositionedStack> ingredients, PositionedStack result, List<PositionedStack> others) {
            if (this.matchPositionedStack(ingredients)) {
                return true;
            }
            if (this.matchPositionedStack(result)) {
                return true;
            }
            return this.matchPositionedStack(others);
        }

        private boolean matchPositionedStack(List<PositionedStack> items) {
            for (PositionedStack pStack : items) {
                if (!this.matchPositionedStack(pStack)) continue;
                return true;
            }
            return false;
        }

        private boolean matchPositionedStack(PositionedStack pStack) {
            if (pStack == null) {
                return false;
            }
            for (ItemStack stack : pStack.items) {
                if (!this.filter.matches(stack)) continue;
                return true;
            }
            return false;
        }
    }
}

