/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.wrapper;

import logisticspipes.asm.wrapper.AbstractWrapper;
import logisticspipes.proxy.interfaces.IGenericProgressProvider;
import net.minecraft.tileentity.TileEntity;

public class GenericProgressProviderWrapper
extends AbstractWrapper
implements IGenericProgressProvider {
    private IGenericProgressProvider provider;
    private final String name;

    GenericProgressProviderWrapper(IGenericProgressProvider provider, String name) {
        this.provider = provider;
        this.name = name;
    }

    @Override
    public boolean isType(TileEntity tile) {
        if (this.isEnabled()) {
            try {
                return this.provider.isType(tile);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (NoClassDefFoundError e) {
                this.handleException(e);
            }
        }
        return false;
    }

    @Override
    public byte getProgress(TileEntity tile) {
        if (this.isEnabled()) {
            try {
                return this.provider.getProgress(tile);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            catch (NoClassDefFoundError e) {
                this.handleException(e);
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return "ProgressProvider";
    }
}

