/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud.modules;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IHUDButton;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.modules.ModuleAdvancedExtractor;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.hud.BasicHUDButton;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class HUDAdvancedExtractor
implements IHUDModuleRenderer {
    private List<IHUDButton> buttons = new ArrayList<IHUDButton>();
    private int selected = 0;
    private ModuleAdvancedExtractor module;

    public HUDAdvancedExtractor(ModuleAdvancedExtractor moduleAdvancedExtractor) {
        this.module = moduleAdvancedExtractor;
        this.buttons.add(new TabButton("Side", 0, -30, -50, 25, 10));
        this.buttons.add(new TabButton("Inv", 1, -5, -50, 25, 10));
    }

    @Override
    public void renderContent(boolean shifted) {
        if (this.selected == 0) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            ForgeDirection d = this.module.getSneakyDirection();
            mc.field_71466_p.func_78276_b("Extract", -22, -22, 0);
            mc.field_71466_p.func_78276_b("from:", -22, -9, 0);
            mc.field_71466_p.func_78276_b(d == ForgeDirection.UNKNOWN ? "DEFAULT" : d.name(), -22, 18, 0);
        } else {
            Minecraft mc = FMLClientHandler.instance().getClient();
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0E-5f);
            ItemStackRenderer.renderItemIdentifierStackListIntoGui(ItemIdentifierStack.getListFromInventory(this.module.getFilterInventory()), null, 0, -25, -32, 3, 9, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.NEVER, true, false, shifted);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-100000.0f);
            if (this.module.areItemsIncluded()) {
                mc.field_71466_p.func_78276_b("Included", -22, 25, 0);
            } else {
                mc.field_71466_p.func_78276_b("Excluded", -22, 25, 0);
            }
        }
    }

    @Override
    public List<IHUDButton> getButtons() {
        return this.buttons;
    }

    private class TabButton
    extends BasicHUDButton {
        private final int mode;

        public TabButton(String name, int mode, int x, int y, int width, int heigth) {
            super(name, x, y, width, heigth);
            this.mode = mode;
        }

        @Override
        public void clicked() {
            HUDAdvancedExtractor.this.selected = this.mode;
        }

        @Override
        public void renderButton(boolean hover, boolean clicked, boolean shifted) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-6f);
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (hover) {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
                if (!clicked) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
                }
            } else {
                GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
            }
            GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
            GuiGraphics.drawGuiBackGround(mc, this.posX * 2, this.posY * 2, (this.posX + this.sizeX) * 2, (this.posY + this.sizeY) * 2 + 15, 0.0f, false, true, true, false, true);
            GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
            if (clicked) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-6f);
            int color = 0;
            color = hover && !clicked ? Color.getValue(Color.LIGHT_YELLOW) : (!clicked ? Color.getValue(Color.BLACK) : Color.getValue(Color.DARK_GREY));
            GL11.glScaled((double)0.8, (double)0.8, (double)1.0);
            mc.field_71466_p.func_78276_b(this.label, (int)((-((double)mc.field_71466_p.func_78256_a(this.label) / 2.5) + (double)this.posX + (double)(this.sizeX / 2)) * 1.25), (int)((double)(this.posY + (this.sizeY - 8) / 2) * 1.25) + 2, color);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.0);
            if (hover) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0E-5f);
        }

        @Override
        public boolean shouldRenderButton() {
            return true;
        }

        @Override
        public boolean buttonEnabled() {
            return this.mode != HUDAdvancedExtractor.this.selected;
        }
    }
}

