/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.api;

import com.miraclem4n.mchat.types.IndicatorType;
import com.miraclem4n.mchat.util.MessageUtil;
import java.util.Map;
import java.util.TreeMap;
import net.milkbowl.vault.permission.Permission;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.dataholder.worlds.WorldsHolder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class API {
    static Permission vPerm;
    static Boolean vaultB;
    static WorldsHolder gmWH;
    static Boolean gmB;
    static PermissionManager pexPermissions;
    static Boolean pexB;
    static Boolean bPermB;
    static Boolean pBukkitB;
    static TreeMap<String, String> varMap;

    public static void initialize() {
        API.setupPlugins();
        varMap = new TreeMap();
    }

    public static void addGlobalVar(String var, String value) {
        if (var == null || var.isEmpty()) {
            return;
        }
        if (value == null) {
            value = "";
        }
        varMap.put("%^global^%|" + var, value);
    }

    public static void addPlayerVar(String pName, String var, String value) {
        if (var == null || var.isEmpty()) {
            return;
        }
        if (value == null) {
            value = "";
        }
        varMap.put(pName + "|" + var, value);
    }

    public static String createHealthBar(Player player) {
        float maxHealth = 20.0f;
        float barLength = 10.0f;
        float health = player.getHealth();
        return API.createBasicBar(health, maxHealth, barLength);
    }

    public static String createFoodBar(Player player) {
        float maxFood = 20.0f;
        float barLength = 10.0f;
        float food = player.getFoodLevel();
        return API.createBasicBar(food, maxFood, barLength);
    }

    public static String createBasicBar(float currentValue, float maxValue, float barLength) {
        int fill = Math.round(currentValue / maxValue * barLength);
        String barColor = (float)fill <= barLength / 4.0f ? "&4" : ((float)fill <= barLength / 7.0f ? "&e" : "&2");
        StringBuilder out = new StringBuilder();
        out.append(barColor);
        int i = 0;
        while ((float)i < barLength) {
            if (i == fill) {
                out.append("&8");
            }
            out.append("|");
            ++i;
        }
        out.append("&f");
        return out.toString();
    }

    public static Boolean checkPermissions(Player player, World world, String node) {
        return API.checkPermissions(player.getName(), world.getName(), node) != false || player.hasPermission(node) || player.isOp();
    }

    public static Boolean checkPermissions(String pName, String world, String node) {
        if (vaultB.booleanValue() && vPerm.has(world, pName, node)) {
            return true;
        }
        if (gmB.booleanValue() && gmWH.getWorldPermissions(pName).getPermissionBoolean(pName, node)) {
            return true;
        }
        if (pexB.booleanValue() && pexPermissions.has(pName, world, node)) {
            return true;
        }
        if (Bukkit.getServer().getPlayer(pName) != null && Bukkit.getServer().getPlayer(pName).hasPermission(node)) {
            return true;
        }
        return false;
    }

    public static Boolean checkPermissions(CommandSender sender, String node) {
        if (vaultB.booleanValue() && vPerm.has(sender, node)) {
            return true;
        }
        return sender.hasPermission(node);
    }

    public static String replace(String source, Map<String, String> changes, IndicatorType type) {
        for (Map.Entry<String, String> entry : changes.entrySet()) {
            source = source.replace(type.getValue() + entry.getKey(), entry.getValue());
        }
        return source;
    }

    public static String replace(String source, String search, String replace, IndicatorType type) {
        return source.replace(type.getValue() + search, replace);
    }

    private static void setupPlugins() {
        PluginManager pm = Bukkit.getServer().getPluginManager();
        Plugin pluginTest = pm.getPlugin("Vault");
        vaultB = pluginTest != null;
        if (vaultB.booleanValue()) {
            MessageUtil.log("[MChat] <Plugin> " + pluginTest.getDescription().getName() + " v" + pluginTest.getDescription().getVersion() + " hooked!.");
            RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (permissionProvider != null) {
                vPerm = (Permission)permissionProvider.getProvider();
            }
            vaultB = vPerm != null;
        }
        if ((pBukkitB = Boolean.valueOf((pluginTest = pm.getPlugin("PermissionsBukkit")) != null)).booleanValue()) {
            MessageUtil.log("[MChat] <Permissions> " + pluginTest.getDescription().getName() + " v" + pluginTest.getDescription().getVersion() + " hooked!.");
        }
        if ((bPermB = Boolean.valueOf((pluginTest = pm.getPlugin("bPermissions")) != null)).booleanValue()) {
            MessageUtil.log("[MChat] <Permissions> " + pluginTest.getDescription().getName() + " v" + pluginTest.getDescription().getVersion() + " hooked!.");
        }
        if ((pexB = Boolean.valueOf((pluginTest = pm.getPlugin("PermissionsEx")) != null)).booleanValue()) {
            pexPermissions = PermissionsEx.getPermissionManager();
            MessageUtil.log("[MChat] <Permissions> " + pluginTest.getDescription().getName() + " v" + pluginTest.getDescription().getVersion() + " hooked!.");
        }
        if ((gmB = Boolean.valueOf((pluginTest = pm.getPlugin("GroupManager")) != null)).booleanValue()) {
            gmWH = ((GroupManager)pluginTest).getWorldsHolder();
            MessageUtil.log("[MChat] <Permissions> " + pluginTest.getDescription().getName() + " v" + pluginTest.getDescription().getVersion() + " hooked!.");
        }
        if (!(vaultB.booleanValue() || pBukkitB.booleanValue() || bPermB.booleanValue() || pexB.booleanValue() || gmB.booleanValue())) {
            MessageUtil.log("[MChat] <Permissions> SuperPerms hooked!.");
        }
    }
}

