/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.api;

import com.miraclem4n.mchat.configs.InfoUtil;
import com.miraclem4n.mchat.types.InfoType;
import com.miraclem4n.mchat.types.config.ConfigType;

public class Writer {
    public static void addBase(String name, InfoType type) {
        String base = type.getName();
        if (type.equals((Object)InfoType.USER)) {
            InfoUtil.getConfig().set(base + "." + name + ".group", (Object)ConfigType.INFO_DEFAULT_GROUP.getString());
        }
        InfoUtil.getConfig().set(base + "." + name + ".info.prefix", (Object)"");
        InfoUtil.getConfig().set(base + "." + name + ".info.suffix", (Object)"");
        Writer.save();
        if (type.equals((Object)InfoType.USER)) {
            Writer.setDGroup(ConfigType.INFO_DEFAULT_GROUP.getString());
        }
    }

    public static void addBase(String player, String group) {
        InfoUtil.getConfig().set("users." + player + ".group", (Object)group);
        InfoUtil.getConfig().set("users." + player + ".info.prefix", (Object)"");
        InfoUtil.getConfig().set("users." + player + ".info.suffix", (Object)"");
        Writer.save();
        Writer.setDGroup(group);
    }

    public static void addWorld(String name, InfoType type, String world) {
        String base = type.getName();
        if (!InfoUtil.getConfig().isSet(base + "." + name)) {
            Writer.addBase(name, type);
        }
        InfoUtil.getConfig().set(base + "." + name + ".worlds." + world + "prefix", (Object)"");
        InfoUtil.getConfig().set(base + "." + name + ".worlds." + world + "suffix", (Object)"");
        Writer.save();
    }

    public static void setInfoVar(String name, InfoType type, String var, Object value) {
        String base = type.getName();
        if (!InfoUtil.getConfig().isSet(base + "." + name)) {
            Writer.addBase(name, type);
        }
        InfoUtil.getConfig().set(base + "." + name + ".info." + var, value);
        Writer.save();
    }

    public static void setWorldVar(String name, InfoType type, String world, String var, Object value) {
        String base = type.getName();
        if (!InfoUtil.getConfig().isSet(base + "." + name + ".worlds." + world)) {
            Writer.addWorld(name, type, world);
        }
        InfoUtil.getConfig().set(base + "." + name + ".worlds." + world + "." + var, value);
        Writer.save();
    }

    public static void setGroup(String player, String group) {
        if (!InfoUtil.getConfig().isSet(player + "." + group)) {
            Writer.addBase(player, group);
        }
        InfoUtil.getConfig().set("users." + player + ".group", (Object)group);
        Writer.save();
    }

    public static void removeBase(String name, InfoType type) {
        String base = type.getName();
        if (InfoUtil.getConfig().isSet(base + "." + name)) {
            InfoUtil.getConfig().set(base + "." + name, null);
            Writer.save();
        }
    }

    public static void removeInfoVar(String name, InfoType type, String var) {
        Writer.setInfoVar(name, type, var, null);
    }

    public static void removeWorld(String name, InfoType type, String world) {
        String base = type.getName();
        if (InfoUtil.getConfig().isSet(base + "." + name) && InfoUtil.getConfig().isSet(base + "." + name + ".worlds." + world)) {
            InfoUtil.getConfig().set(base + "." + name + ".worlds." + world, null);
            Writer.save();
        }
    }

    public static void removeWorldVar(String name, InfoType type, String world, String var) {
        Writer.setWorldVar(name, type, world, var, null);
    }

    private static void setDGroup(String group) {
        if (!InfoUtil.getConfig().isSet("groups." + group)) {
            InfoUtil.getConfig().set("groups." + group + ".info.prefix", (Object)"");
            InfoUtil.getConfig().set("groups." + group + ".info.suffix", (Object)"");
            Writer.save();
        }
    }

    private static void save() {
        InfoUtil.save();
    }
}

