/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.channels;

import com.miraclem4n.mchat.types.ChannelType;
import com.miraclem4n.mchat.util.MessageUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Channel {
    HashMap<String, Boolean> occupants;
    String name;
    String prefix;
    String suffix;
    String password;
    ChannelType type;
    Integer distance;
    Boolean passworded;
    Boolean defaulted;

    public Channel(String name, ChannelType type, String prefix, String suffix, Boolean passworded, String password, Integer distance, Boolean defaulted) {
        this.name = name.toLowerCase();
        this.type = type;
        this.prefix = prefix;
        this.suffix = suffix;
        this.passworded = passworded;
        this.password = password;
        this.distance = distance;
        this.defaulted = defaulted;
        this.occupants = new HashMap();
    }

    public Channel(String name) {
        this.name = name.toLowerCase();
        this.type = ChannelType.GLOBAL;
        this.prefix = "[";
        this.suffix = "]";
        this.passworded = false;
        this.password = "";
        this.distance = -1;
        this.defaulted = false;
        this.occupants = new HashMap();
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setType(ChannelType type) {
        if (type == null) {
            type = ChannelType.GLOBAL;
        }
        this.type = type;
    }

    public ChannelType getType() {
        return this.type;
    }

    public Set<String> getOccupants() {
        return this.occupants.keySet();
    }

    public Set<String> getActiveOccupants() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : this.occupants.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public void addOccupant(String occupant) {
        this.addOccupant(occupant, true);
    }

    public void addOccupant(String occupant, Boolean state) {
        if (occupant == null || state == null || this.occupants.get(occupant) != null) {
            return;
        }
        this.occupants.put(occupant, state);
    }

    public void removeOccupant(String occupant) {
        if (occupant == null || this.occupants.get(occupant) == null) {
            return;
        }
        this.occupants.remove(occupant);
    }

    public Boolean getOccupantAvailability(String occupant) {
        if (occupant == null || this.occupants.get(occupant) == null) {
            return false;
        }
        return this.occupants.get(occupant);
    }

    public void setOccupantAvailability(String occupant, Boolean state) {
        if (occupant == null || state == null || this.occupants.get(occupant) == null) {
            return;
        }
        this.occupants.put(occupant, state);
    }

    public void setPrefix(String prefix) {
        if (prefix == null) {
            return;
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        if (suffix == null) {
            return;
        }
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setDistance(Integer distance) {
        if (distance == null) {
            return;
        }
        this.distance = distance;
    }

    public Integer getDistance() {
        return this.distance;
    }

    public Boolean isPassworded() {
        return this.passworded;
    }

    public void setPassworded(Boolean passworded, String password) {
        if (passworded == null || password == null) {
            return;
        }
        this.type = ChannelType.PASSWORD;
        this.passworded = passworded;
        this.password = password;
    }

    public void setPassword(String password) {
        if (password == null) {
            return;
        }
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean isDefault() {
        return this.defaulted;
    }

    public void setDefault(Boolean defaulted) {
        if (defaulted == null) {
            return;
        }
        this.defaulted = defaulted;
    }

    public void sendMessageFrom(Player player, String message) {
        if (player == null || message == null) {
            return;
        }
        String msg = MessageUtil.addColour(this.prefix + this.name + this.suffix) + " " + message;
        for (String names : this.getActiveOccupants()) {
            Player playerz = Bukkit.getServer().getPlayer(names);
            if (playerz == null) continue;
            if (this.getType() == ChannelType.PASSWORD || this.getType() == ChannelType.PRIVATE || this.getType() == ChannelType.GLOBAL) {
                playerz.sendMessage(msg);
                continue;
            }
            if (this.getType() == ChannelType.LOCAL) {
                if (!playerz.getWorld().getName().equals(player.getWorld().getName()) || !(playerz.getLocation().distance(player.getLocation()) > (double)this.distance.intValue())) continue;
                playerz.sendMessage(msg);
                continue;
            }
            if (this.getType() == ChannelType.WORLD) {
                if (!playerz.getWorld().getName().equals(player.getWorld().getName())) continue;
                playerz.sendMessage(msg);
                continue;
            }
            if (this.getType() != ChannelType.CHUNK || !playerz.getWorld().getName().equals(player.getWorld().getName()) || playerz.getLocation().getChunk() != player.getLocation().getChunk()) continue;
            playerz.sendMessage(msg);
        }
        MessageUtil.log(msg);
    }

    public void broadcastMessage(String message) {
        if (message == null) {
            return;
        }
        String msg = MessageUtil.addColour(this.prefix + this.name + this.suffix + " " + message);
        for (String names : this.getActiveOccupants()) {
            Player playerz = Bukkit.getServer().getPlayer(names);
            if (playerz == null) continue;
            playerz.sendMessage(msg);
        }
        MessageUtil.log(msg);
    }
}

