/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.channels;

import com.miraclem4n.mchat.channels.Channel;
import com.miraclem4n.mchat.configs.ChannelUtil;
import com.miraclem4n.mchat.types.ChannelEditType;
import com.miraclem4n.mchat.types.ChannelType;
import java.util.HashSet;
import java.util.Set;

public class ChannelManager {
    static Set<Channel> channels = new HashSet<Channel>();

    public static void initialize() {
        channels = new HashSet<Channel>();
        ChannelManager.loadChannels();
    }

    public static Set<Channel> getChannels() {
        ChannelManager.loadChannels();
        return channels;
    }

    public static void loadChannels() {
        for (String key : ChannelUtil.getConfig().getKeys(false)) {
            ChannelType type = ChannelType.fromName(ChannelUtil.getConfig().getString(key + ".type"));
            String prefix = ChannelUtil.getConfig().getString(key + ".prefix", "[");
            String suffix = ChannelUtil.getConfig().getString(key + ".suffix", "]");
            Boolean passworded = ChannelUtil.getConfig().getBoolean(key + ".passworded", false);
            String password = ChannelUtil.getConfig().getString(key + ".password", "");
            Integer distance = ChannelUtil.getConfig().getInt(key + ".distance", -1);
            Boolean defaulted = ChannelUtil.getConfig().getBoolean(key + ".default", false);
            if (type == null) {
                type = ChannelType.GLOBAL;
            }
            channels.add(new Channel(key.toLowerCase(), type, prefix, suffix, passworded, password, distance, defaulted));
        }
    }

    public static void loadChannel(String name) {
        ChannelType type = ChannelType.fromName(ChannelUtil.getConfig().getString(name + ".type"));
        String prefix = ChannelUtil.getConfig().getString(name + ".prefix", "[");
        String suffix = ChannelUtil.getConfig().getString(name + ".suffix", "]");
        Boolean passworded = ChannelUtil.getConfig().getBoolean(name + ".passworded", false);
        String password = ChannelUtil.getConfig().getString(name + ".password", "");
        Integer distance = ChannelUtil.getConfig().getInt(name + ".distance", -1);
        Boolean defaulted = ChannelUtil.getConfig().getBoolean(name + ".default", false);
        channels.add(new Channel(name.toLowerCase(), type, prefix, suffix, passworded, password, distance, defaulted));
    }

    public static void reloadChannels() {
        for (String key : ChannelUtil.getConfig().getKeys(false)) {
            if (ChannelManager.getChannel(key) != null) {
                Channel channel = ChannelManager.getChannel(key);
                channel.setType(ChannelType.fromName(ChannelUtil.getConfig().getString(key + ".type")));
                channel.setPrefix(ChannelUtil.getConfig().getString(key + ".prefix", "["));
                channel.setSuffix(ChannelUtil.getConfig().getString(key + ".suffix", "]"));
                channel.setPassword(ChannelUtil.getConfig().getString(key + ".password", ""));
                channel.setPassworded(ChannelUtil.getConfig().getBoolean(key + ".passworded", false), channel.getPassword());
                channel.setDistance(ChannelUtil.getConfig().getInt(key + ".distance", -1));
                channel.setDefault(ChannelUtil.getConfig().getBoolean(key + ".default", false));
                continue;
            }
            ChannelManager.loadChannel(key);
        }
    }

    public static void createChannel(String name, ChannelType type, String prefix, String suffix, Boolean passworded, String password, Integer distance, Boolean defaulted) {
        channels.add(new Channel(name.toLowerCase(), type, prefix, suffix, passworded, password, distance, defaulted));
        ChannelUtil.getConfig().set(name.toLowerCase() + ".type", (Object)type.getName());
        ChannelUtil.getConfig().set(name.toLowerCase() + ".prefix", (Object)prefix);
        ChannelUtil.getConfig().set(name.toLowerCase() + ".suffix", (Object)suffix);
        ChannelUtil.getConfig().set(name.toLowerCase() + ".passworded", (Object)passworded);
        ChannelUtil.getConfig().set(name.toLowerCase() + ".password", (Object)password);
        ChannelUtil.getConfig().set(name.toLowerCase() + ".distance", (Object)distance);
        ChannelUtil.getConfig().set(name.toLowerCase() + ".default", (Object)defaulted);
        if (defaulted.booleanValue()) {
            ChannelManager.setDefaultChannel(name);
        }
        ChannelUtil.save();
    }

    public static void removeChannel(String name) {
        Boolean isReal = false;
        for (Channel channel : channels) {
            if (!channel.getName().equalsIgnoreCase(name)) continue;
            isReal = true;
            break;
        }
        if (isReal.booleanValue()) {
            channels.remove(ChannelManager.getChannel(name));
            ChannelUtil.getConfig().set(name, null);
            ChannelUtil.save();
        }
    }

    public static Channel getChannel(String name) {
        for (Channel channel : channels) {
            if (!channel.getName().equalsIgnoreCase(name)) continue;
            return channel;
        }
        return null;
    }

    public static void saveChannels() {
        for (Channel channel : channels) {
            ChannelManager.saveChannel(channel);
        }
    }

    public static void saveChannel(Channel channel) {
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".type", (Object)channel.getType().getName().toLowerCase());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".prefix", (Object)channel.getPrefix());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".suffix", (Object)channel.getSuffix());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".passworded", (Object)channel.isPassworded());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".password", (Object)channel.getPassword());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".distance", (Object)channel.getDistance());
        ChannelUtil.getConfig().set(channel.getName().toLowerCase() + ".default", (Object)channel.isDefault());
        ChannelUtil.save();
    }

    public static void setDefaultChannel(String name) {
        Boolean hasDefaulted = false;
        for (Channel channel : channels) {
            if (channel.getName().equalsIgnoreCase(name)) {
                channel.setDefault(true);
                ChannelManager.saveChannel(channel);
                hasDefaulted = true;
                continue;
            }
            if (!channel.isDefault().booleanValue() || !hasDefaulted.booleanValue()) continue;
            channel.setDefault(false);
            ChannelManager.saveChannel(channel);
        }
    }

    public static Channel getDefaultChannel() {
        for (Channel channel : channels) {
            if (!channel.isDefault().booleanValue()) continue;
            return channel;
        }
        return null;
    }

    public static Set<Channel> getPlayersActiveChannels(String player) {
        HashSet<Channel> channels = new HashSet<Channel>();
        for (Channel channelz : ChannelManager.getChannels()) {
            if (!channelz.getActiveOccupants().contains(player)) continue;
            channels.add(channelz);
        }
        return channels;
    }

    public static Set<Channel> getPlayersChannels(String player) {
        HashSet<Channel> channels = new HashSet<Channel>();
        for (Channel channelz : ChannelManager.getChannels()) {
            if (!channelz.getOccupants().contains(player)) continue;
            channels.add(channelz);
        }
        return channels;
    }

    public static void editChannel(Channel channel, ChannelEditType type, Object option) {
        if (option.getClass() == type.getOptionClass()) {
            if (type.getName().equalsIgnoreCase("Name")) {
                ChannelUtil.getConfig().set(channel.getName(), null);
                channel.setName((String)option);
            } else if (type.getName().equalsIgnoreCase("Default")) {
                ChannelManager.setDefaultChannel(channel.getName());
            } else if (type.getName().equalsIgnoreCase("Distance")) {
                channel.setDistance((Integer)option);
            } else if (type.getName().equalsIgnoreCase("Password")) {
                channel.setPassword((String)option);
            } else if (type.getName().equalsIgnoreCase("Passworded")) {
                channel.setPassworded((Boolean)option, channel.getPassword());
            } else if (type.getName().equalsIgnoreCase("Prefix")) {
                channel.setPrefix((String)option);
            } else if (type.getName().equalsIgnoreCase("Suffix")) {
                channel.setSuffix((String)option);
            } else if (type.getName().equalsIgnoreCase("Type")) {
                channel.setType((ChannelType)((Object)option));
            }
            ChannelManager.saveChannel(channel);
        }
    }
}

