/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.configs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUtil {
    static YamlConfiguration config;
    static File file;
    static ArrayList<String> meAliases;
    static ArrayList<String> whoAliases;
    static ArrayList<String> listAliases;
    static ArrayList<String> sayAliases;
    static ArrayList<String> afkAliases;
    static ArrayList<String> afkOtherAliases;
    static ArrayList<String> shoutAliases;
    static ArrayList<String> muteAliases;
    static ArrayList<String> pmAliases;
    static ArrayList<String> replyAliases;
    static ArrayList<String> inviteAliases;
    static ArrayList<String> acceptAliases;
    static ArrayList<String> denyAliases;
    static ArrayList<String> leaveAliases;
    static ArrayList<String> mChannelAliases;
    static HashMap<String, List<String>> aliasMap;

    public static void initialize() {
        ConfigUtil.load();
    }

    public static void dispose() {
        config = null;
        file = null;
        aliasMap = null;
    }

    public static void load() {
        file = new File("plugins/mChatSuite/config.yml");
        config = YamlConfiguration.loadConfiguration((File)file);
        config.options().indent(4);
        config.options().header("MChat Config");
        ConfigUtil.loadDefaults();
    }

    public static void unload() {
    }

    private static void loadDefaults() {
        ConfigUtil.removeOption("auto-Changed");
        ConfigUtil.removeOption("mchat.suppressMessages");
        ConfigUtil.removeOption("mchat.enableList");
        ConfigUtil.editOption("mchat-message-format", "format.chat");
        ConfigUtil.editOption("mchat-API-only", "mchat.apiOnly");
        ConfigUtil.editOption("mchat-format-events", "mchat.formatEvents");
        ConfigUtil.editOption("mchat-chat-distance", "mchat.chatDistance");
        ConfigUtil.editOption("mchat-info-only", "info.useNewInfo");
        ConfigUtil.editOption("mchat-oldNodes-only", "info.useOldNodes");
        ConfigUtil.editOption("mchat-add-info-players", "info.addNewPlayers");
        ConfigUtil.editOption("mchat.formatEvents", "mchat.alter.events");
        ConfigUtil.editOption("mchat.alterEvents", "mchat.alter.events");
        ConfigUtil.editOption("mchat.alterDeathMessages", "mchat.alter.death");
        ConfigUtil.checkOption("format.chat", "+p+dn+s&f: +m");
        ConfigUtil.checkOption("mchat.apiOnly", false);
        ConfigUtil.checkOption("mchat.alter.events", true);
        ConfigUtil.checkOption("mchat.alter.death", true);
        ConfigUtil.checkOption("mchat.chatDistance", -1.0);
        ConfigUtil.checkOption("mchat.varIndicator", "+");
        ConfigUtil.checkOption("mchat.cusVarIndicator", "-");
        ConfigUtil.checkOption("mchat.localeVarIndicator", "%");
        ConfigUtil.checkOption("mchat.spout", true);
        ConfigUtil.checkOption("mchat.IPCensor", true);
        ConfigUtil.checkOption("mchat.cLockRange", 3);
        ConfigUtil.checkOption("suppress.useDeath", false);
        ConfigUtil.checkOption("suppress.useJoin", false);
        ConfigUtil.checkOption("suppress.useKick", false);
        ConfigUtil.checkOption("suppress.useQuit", false);
        ConfigUtil.checkOption("suppress.maxDeath", 30);
        ConfigUtil.checkOption("suppress.maxJoin", 30);
        ConfigUtil.checkOption("suppress.maxKick", 30);
        ConfigUtil.checkOption("suppress.maxQuit", 30);
        ConfigUtil.checkOption("info.useNewInfo", false);
        ConfigUtil.checkOption("info.useLeveledNodes", false);
        ConfigUtil.checkOption("info.useOldNodes", false);
        ConfigUtil.checkOption("info.addNewPlayers", false);
        ConfigUtil.checkOption("info.defaultGroup", "default");
        ConfigUtil.checkOption("mchate.enable", false);
        ConfigUtil.checkOption("mchate.eHQAFK", true);
        ConfigUtil.checkOption("mchate.useGroupedList", true);
        ConfigUtil.checkOption("mchate.listVar", "group");
        ConfigUtil.checkOption("mchate.collapsedListVars", "default,Default");
        ConfigUtil.checkOption("mchate.AFKTimer", 30);
        ConfigUtil.checkOption("mchate.AFKKickTimer", 120);
        ConfigUtil.checkOption("mchate.useAFKList", false);
        ConfigUtil.checkOption("pmchat.enable", false);
        ConfigUtil.checkOption("pmchat.spoutPM", false);
        ConfigUtil.loadAliases();
        ConfigUtil.checkOption("aliases.mchatme", meAliases);
        ConfigUtil.checkOption("aliases.mchatlist", listAliases);
        ConfigUtil.checkOption("aliases.mchatsay", sayAliases);
        ConfigUtil.checkOption("aliases.mchatafk", afkAliases);
        ConfigUtil.checkOption("aliases.mchatafkother", afkOtherAliases);
        ConfigUtil.checkOption("aliases.pmchat", pmAliases);
        ConfigUtil.checkOption("aliases.pmchatreply", replyAliases);
        ConfigUtil.checkOption("aliases.pmchatinvite", inviteAliases);
        ConfigUtil.checkOption("aliases.pmchataccept", acceptAliases);
        ConfigUtil.checkOption("aliases.pmchatdeny", denyAliases);
        ConfigUtil.checkOption("aliases.pmchatleave", leaveAliases);
        ConfigUtil.checkOption("aliases.mchatshout", shoutAliases);
        ConfigUtil.checkOption("aliases.mchatmute", muteAliases);
        ConfigUtil.checkOption("aliases.mchannel", mChannelAliases);
        ConfigUtil.unloadAliases();
        ConfigUtil.setupAliasMap();
    }

    public static void set(String key, Object obj) {
        config.set(key, obj);
        ConfigUtil.save();
    }

    public static Boolean save() {
        try {
            config.save(file);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static YamlConfiguration getConfig() {
        return config;
    }

    public static HashMap<String, List<String>> getAliasMap() {
        return aliasMap;
    }

    private static void checkOption(String option, Object defValue) {
        if (!config.isSet(option)) {
            ConfigUtil.set(option, defValue);
        }
    }

    private static void editOption(String oldOption, String newOption) {
        if (config.isSet(oldOption)) {
            ConfigUtil.set(newOption, config.get(oldOption));
            ConfigUtil.set(oldOption, null);
        }
    }

    private static void removeOption(String option) {
        if (config.isSet(option)) {
            ConfigUtil.set(option, null);
        }
    }

    private static void loadAliases() {
        meAliases.add("me");
        whoAliases.add("who");
        listAliases.add("list");
        listAliases.add("online");
        listAliases.add("playerlist");
        sayAliases.add("say");
        afkAliases.add("afk");
        afkAliases.add("away");
        afkOtherAliases.add("afko");
        afkOtherAliases.add("awayother");
        afkOtherAliases.add("awayo");
        shoutAliases.add("shout");
        shoutAliases.add("yell");
        muteAliases.add("mute");
        muteAliases.add("quiet");
        pmAliases.add("pm");
        pmAliases.add("msg");
        pmAliases.add("message");
        pmAliases.add("m");
        pmAliases.add("tell");
        pmAliases.add("t");
        replyAliases.add("reply");
        replyAliases.add("r");
        inviteAliases.add("invite");
        acceptAliases.add("accept");
        denyAliases.add("deny");
        leaveAliases.add("leave");
        mChannelAliases.add("channel");
    }

    private static void unloadAliases() {
        meAliases.clear();
        whoAliases.clear();
        listAliases.clear();
        sayAliases.clear();
        afkAliases.clear();
        afkOtherAliases.clear();
        shoutAliases.clear();
        muteAliases.clear();
        pmAliases.clear();
        replyAliases.clear();
        inviteAliases.clear();
        acceptAliases.clear();
        denyAliases.clear();
        leaveAliases.clear();
        mChannelAliases.clear();
    }

    private static void setupAliasMap() {
        Set keys = config.getConfigurationSection("aliases").getKeys(false);
        for (String key : keys) {
            aliasMap.put(key, config.getStringList("aliases." + key));
        }
    }

    static {
        meAliases = new ArrayList();
        whoAliases = new ArrayList();
        listAliases = new ArrayList();
        sayAliases = new ArrayList();
        afkAliases = new ArrayList();
        afkOtherAliases = new ArrayList();
        shoutAliases = new ArrayList();
        muteAliases = new ArrayList();
        pmAliases = new ArrayList();
        replyAliases = new ArrayList();
        inviteAliases = new ArrayList();
        acceptAliases = new ArrayList();
        denyAliases = new ArrayList();
        leaveAliases = new ArrayList();
        mChannelAliases = new ArrayList();
        aliasMap = new HashMap();
    }
}

