/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.configs;

import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;

public class LocaleUtil {
    static YamlConfiguration config;
    static File file;

    public static void initialize() {
        LocaleUtil.load();
    }

    public static void load() {
        file = new File("plugins/mChatSuite/locale.yml");
        config = YamlConfiguration.loadConfiguration((File)file);
        config.options().indent(4);
        config.options().header("MChat Locale");
        LocaleUtil.loadDefaults();
    }

    private static void loadDefaults() {
        LocaleUtil.checkOption("format.forward", "[F]");
        LocaleUtil.checkOption("format.local", "[L]");
        LocaleUtil.checkOption("format.pm.received", "%sender &1-&2-&3-&4> &fMe: %msg");
        LocaleUtil.checkOption("format.pm.sent", "&fMe &1-&2-&3-&4> &4%recipient&f: %msg");
        LocaleUtil.checkOption("format.say", "&6[Server]&e %msg");
        LocaleUtil.checkOption("format.shout", "[Shout]");
        LocaleUtil.checkOption("format.spy", "[Spy]");
        LocaleUtil.checkOption("format.date", "HH:mm:ss");
        LocaleUtil.checkOption("format.name", "+p+dn+s&e");
        LocaleUtil.checkOption("format.tabbedList", "+p+dn+s");
        LocaleUtil.checkOption("format.listCmd", "+p+dn+s");
        LocaleUtil.checkOption("format.me", "* +p+dn+s&e +m");
        LocaleUtil.checkOption("message.afk.afk", "AFK");
        LocaleUtil.checkOption("message.afk.default", "Away From Keyboard");
        LocaleUtil.checkOption("message.config.reloaded", "%config Reloaded.");
        LocaleUtil.checkOption("message.config.updated", "%config has been updated.");
        LocaleUtil.checkOption("message.convo.accepted", "Convo request with &5'&4%player&5'&4 has been accepted.");
        LocaleUtil.checkOption("message.convo.convo", "&4[Convo] ");
        LocaleUtil.checkOption("message.convo.denied", "You have denied a Convo request from &5'&4%player&5'&4.");
        LocaleUtil.checkOption("message.convo.ended", "Conversation with '%player' has ended.");
        LocaleUtil.checkOption("message.convo.hasRequest", "&5'&4%player&5'&4 Already has a Convo request.");
        LocaleUtil.checkOption("message.convo.inviteSent", "You have invited &5'&4%player&5'&4 to have a Convo.");
        LocaleUtil.checkOption("message.convo.invited", "You have been invited to a Convo by &5'&4%player&5'&4 use /pmchataccept to accept.");
        LocaleUtil.checkOption("message.convo.left", "You have left the Conversation with '%player'.");
        LocaleUtil.checkOption("message.convo.noPending", "No pending Convo request.");
        LocaleUtil.checkOption("message.convo.notIn", "You are not currently in a Convo.");
        LocaleUtil.checkOption("message.convo.notStarted", "Convo request with &5'&4%player&5'&4 has been denied.");
        LocaleUtil.checkOption("message.convo.started", "You have started a Convo with &5'&4%player&5'&4.");
        LocaleUtil.checkOption("message.general.mute", "Target '%player' successfully %muted. To %mute use this command again.");
        LocaleUtil.checkOption("message.general.noPerms", "You do not have '%permission'.");
        LocaleUtil.checkOption("message.info.alteration", "Info Alteration Successful.");
        LocaleUtil.checkOption("message.list.header", "&6-- There are &8%players&6 out of the maximum of &8%max&6 Players online. --");
        LocaleUtil.checkOption("message.player.afk", "%player is now AFK. [ %reason ]");
        LocaleUtil.checkOption("message.player.notAfk", "%player is no longer AFK.");
        LocaleUtil.checkOption("message.player.notFound", "");
        LocaleUtil.checkOption("message.player.notOnline", "");
        LocaleUtil.checkOption("message.player.stillAfk", "You are still AFK.");
        LocaleUtil.checkOption("message.pm.noPm", "No one has yet PM'd you.");
        LocaleUtil.checkOption("message.shout.noInput", "You can't shout nothing!");
        LocaleUtil.checkOption("message.spout.colour", "dark_red");
        LocaleUtil.checkOption("message.spout.pmFrom", "[PMChat] From:");
        LocaleUtil.checkOption("message.spout.typing", "*Typing*");
        LocaleUtil.checkOption("message.event.join", "%player has joined the game.");
        LocaleUtil.checkOption("message.event.leave", "%player has left the game.");
        LocaleUtil.checkOption("message.event.kick", "%player has been kicked from the game. [ %reason ]");
        LocaleUtil.checkOption("message.death.inFire", "%player went up in flames.");
        LocaleUtil.checkOption("message.death.onFire", "%player burned to death.");
        LocaleUtil.checkOption("message.death.lava", "%player tried to swim in lava.");
        LocaleUtil.checkOption("message.death.inWall", "%player suffocated in a wall.");
        LocaleUtil.checkOption("message.death.drown", "%player drowned.");
        LocaleUtil.checkOption("message.death.starve", "%player starved to death.");
        LocaleUtil.checkOption("message.death.cactus", "%player was pricked to death.");
        LocaleUtil.checkOption("message.death.fall", "%player hit the ground too hard.");
        LocaleUtil.checkOption("message.death.outOfWorld", "%player fell out of the world.");
        LocaleUtil.checkOption("message.death.generic", "%player died.");
        LocaleUtil.checkOption("message.death.explosion", "%player blew up.");
        LocaleUtil.checkOption("message.death.magic", "%player was killed by magic.");
        LocaleUtil.checkOption("message.death.entity", "%player was slain by %killer.");
        LocaleUtil.checkOption("message.death.arrow", "%player was shot by %killer.");
        LocaleUtil.checkOption("message.death.fireball", "%player was fireballed by %killer.");
        LocaleUtil.checkOption("message.death.thrown", "%player was pummeled by %killer.");
        LocaleUtil.checkOption("message.heroes.isMaster", "The Great");
        LocaleUtil.checkOption("message.heroes.notMaster", "The Squire");
    }

    public static void set(String key, Object obj) {
        config.set(key, obj);
        LocaleUtil.save();
    }

    public static Boolean save() {
        try {
            config.save(file);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static YamlConfiguration getConfig() {
        return config;
    }

    private static void checkOption(String option, Object defValue) {
        if (!config.isSet(option)) {
            LocaleUtil.set(option, defValue);
        }
    }
}

