/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.events;

import com.miraclem4n.mchat.MChat;
import com.miraclem4n.mchat.api.API;
import com.miraclem4n.mchat.api.Parser;
import com.miraclem4n.mchat.types.config.ConfigType;
import com.miraclem4n.mchat.types.config.LocaleType;
import com.miraclem4n.mchat.util.MessageUtil;
import java.util.Date;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.getspout.spoutapi.player.SpoutPlayer;

public class ChatListener
implements Listener {
    MChat plugin;

    public ChatListener(MChat instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String pName = player.getName();
        if (this.plugin.isMuted.get(pName) != null && this.plugin.isMuted.get(pName).booleanValue()) {
            event.setCancelled(true);
            return;
        }
        String world = player.getWorld().getName();
        String pLName = Parser.parseTabbedList(pName, world);
        String msg = event.getMessage();
        String eventFormat = Parser.parseChatMessage(pName, world, msg);
        if (msg == null) {
            return;
        }
        if (pLName.length() > 15) {
            pLName = pLName.substring(0, 16);
            this.setListName(player, pLName);
        } else {
            this.setListName(player, pLName);
        }
        if (ConfigType.PMCHAT_ENABLE.getBoolean().booleanValue()) {
            if (this.plugin.isConv.get(pName) == null) {
                this.plugin.isConv.put(pName, false);
            }
            if (this.plugin.isConv.get(pName).booleanValue()) {
                Player recipient = this.plugin.getServer().getPlayer(this.plugin.chatPartner.get(pName));
                recipient.sendMessage(MessageUtil.addColour(LocaleType.MESSAGE_CONVERSATION_CONVERSATION.getVal() + eventFormat));
                player.sendMessage(MessageUtil.addColour(LocaleType.MESSAGE_CONVERSATION_CONVERSATION.getVal() + eventFormat));
                MessageUtil.log(MessageUtil.addColour(LocaleType.MESSAGE_CONVERSATION_CONVERSATION.getVal() + eventFormat));
                event.setCancelled(true);
            }
        }
        if (ConfigType.MCHATE_ENABLE.getBoolean().booleanValue()) {
            if (this.plugin.isAFK.get(pName) != null && this.plugin.isAFK.get(pName).booleanValue()) {
                player.performCommand("mchatafk");
            }
            this.plugin.lastMove.put(pName, new Date().getTime());
        }
        if (this.plugin.spoutB.booleanValue()) {
            SpoutPlayer sPlayer = (SpoutPlayer)player;
            final String sPName = pName;
            sPlayer.setTitle(ChatColor.valueOf((String)LocaleType.MESSAGE_SPOUT_COLOUR.getRaw().toUpperCase()) + "- " + MessageUtil.addColour(msg) + ChatColor.valueOf((String)LocaleType.MESSAGE_SPOUT_COLOUR.getRaw().toUpperCase()) + " -" + '\n' + Parser.parsePlayerName(pName, world));
            this.plugin.chatt.put(pName, false);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    SpoutPlayer sPlayer = (SpoutPlayer)ChatListener.this.plugin.getServer().getPlayer(sPName);
                    if (sPlayer != null) {
                        sPlayer.setTitle(Parser.parsePlayerName(sPName, sPlayer.getWorld().getName()));
                    }
                }
            }, 140L);
        }
        if (ConfigType.MCHAT_CHAT_DISTANCE.getDouble() > 0.0) {
            for (Player players : this.plugin.getServer().getOnlinePlayers()) {
                if (players.getWorld() == player.getWorld() && !(players.getLocation().distance(player.getLocation()) > ConfigType.MCHAT_CHAT_DISTANCE.getDouble())) continue;
                if (this.isSpy(players.getName(), players.getWorld().getName()).booleanValue()) {
                    players.sendMessage(eventFormat.replace(LocaleType.FORMAT_LOCAL.getVal(), LocaleType.FORMAT_FORWARD.getVal()));
                }
                event.getRecipients().remove(players);
            }
        }
        event.setFormat(eventFormat);
    }

    Boolean isSpy(String player, String world) {
        if (API.checkPermissions(player, world, "mchat.spy").booleanValue()) {
            MChat.isSpying.put(player, true);
            return true;
        }
        MChat.isSpying.put(player, false);
        return false;
    }

    void setListName(Player player, String listName) {
        try {
            player.setPlayerListName(listName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

