/*
 * Decompiled with CFR 0.152.
 */
package com.miraclem4n.mchat.types;

import com.miraclem4n.mchat.types.ChannelType;
import java.util.HashMap;

public enum ChannelEditType {
    DEFAULT("Default", Boolean.class),
    PASSWORD("Password", String.class),
    PASSWORDED("Passworded", Boolean.class),
    TYPE("Type", ChannelType.class),
    NAME("Name", String.class),
    PREFIX("Prefix", String.class),
    SUFFIX("Suffix", String.class),
    DISTANCE("Distance", Integer.class);

    private final String name;
    private final Class<?> clazz;
    private static final HashMap<String, ChannelEditType> nMap;

    private ChannelEditType(String name, Class<?> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getOptionClass() {
        return this.clazz;
    }

    public static ChannelEditType fromName(String name) {
        if (name == null) {
            return null;
        }
        return nMap.get(name.toLowerCase());
    }

    static {
        nMap = new HashMap();
        for (ChannelEditType type : ChannelEditType.values()) {
            nMap.put(type.name.toLowerCase(), type);
        }
    }
}

