/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.chat.plugins;

import java.util.logging.Logger;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class Chat_PermissionsEx
extends Chat {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "PermissionsEx_Chat";
    private Plugin plugin = null;
    private PermissionsEx chat = null;

    public Chat_PermissionsEx(Plugin plugin, Permission perms) {
        super(perms);
        Plugin p;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.chat == null && (p = plugin.getServer().getPluginManager().getPlugin("PermissionsEx")) != null && p.isEnabled()) {
            this.chat = (PermissionsEx)p;
            log.info(String.format("[%s][Chat] %s hooked.", plugin.getDescription().getName(), "PermissionsEx_Chat"));
        }
    }

    @Override
    public String getName() {
        return "PermissionsEx_Chat";
    }

    @Override
    public boolean isEnabled() {
        if (this.chat == null) {
            return false;
        }
        return this.chat.isEnabled();
    }

    @Override
    public int getPlayerInfoInteger(String world, String playerName, String node, int defaultValue) {
        return PermissionsEx.getPermissionManager().getUser(playerName).getOptionInteger(node, world, defaultValue);
    }

    @Override
    public double getPlayerInfoDouble(String world, String playerName, String node, double defaultValue) {
        return PermissionsEx.getPermissionManager().getUser(playerName).getOptionDouble(node, world, defaultValue);
    }

    @Override
    public boolean getPlayerInfoBoolean(String world, String playerName, String node, boolean defaultValue) {
        return PermissionsEx.getPermissionManager().getUser(playerName).getOptionBoolean(node, world, defaultValue);
    }

    @Override
    public String getPlayerInfoString(String world, String playerName, String node, String defaultValue) {
        return PermissionsEx.getPermissionManager().getUser(playerName).getOption(node, world, defaultValue);
    }

    @Override
    public void setPlayerInfoInteger(String world, String playerName, String node, int value) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            user.setOption(node, String.valueOf(value), world);
        }
    }

    @Override
    public void setPlayerInfoDouble(String world, String playerName, String node, double value) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            user.setOption(node, String.valueOf(value), world);
        }
    }

    @Override
    public void setPlayerInfoBoolean(String world, String playerName, String node, boolean value) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            user.setOption(node, String.valueOf(value), world);
        }
    }

    @Override
    public void setPlayerInfoString(String world, String playerName, String node, String value) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            user.setOption(node, String.valueOf(value), world);
        }
    }

    @Override
    public int getGroupInfoInteger(String world, String groupName, String node, int defaultValue) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return defaultValue;
        }
        return group.getOptionInteger(node, world, defaultValue);
    }

    @Override
    public void setGroupInfoInteger(String world, String groupName, String node, int value) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        group.setOption(node, world, String.valueOf(value));
    }

    @Override
    public double getGroupInfoDouble(String world, String groupName, String node, double defaultValue) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return defaultValue;
        }
        return group.getOptionDouble(node, world, defaultValue);
    }

    @Override
    public void setGroupInfoDouble(String world, String groupName, String node, double value) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        group.setOption(node, world, String.valueOf(value));
    }

    @Override
    public boolean getGroupInfoBoolean(String world, String groupName, String node, boolean defaultValue) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return defaultValue;
        }
        return group.getOptionBoolean(node, world, defaultValue);
    }

    @Override
    public void setGroupInfoBoolean(String world, String groupName, String node, boolean value) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        group.setOption(node, world, String.valueOf(value));
    }

    @Override
    public String getGroupInfoString(String world, String groupName, String node, String defaultValue) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return defaultValue;
        }
        return group.getOption(node, world, defaultValue);
    }

    @Override
    public void setGroupInfoString(String world, String groupName, String node, String value) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        group.setOption(node, world, value);
    }

    @Override
    public String getPlayerPrefix(String world, String playerName) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            return user.getPrefix(world);
        }
        return null;
    }

    @Override
    public String getPlayerSuffix(String world, String playerName) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            return user.getSuffix(world);
        }
        return null;
    }

    @Override
    public void setPlayerSuffix(String world, String player, String suffix) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(player);
        if (user != null) {
            user.setSuffix(suffix, world);
        }
    }

    @Override
    public void setPlayerPrefix(String world, String player, String prefix) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(player);
        if (user != null) {
            user.setPrefix(prefix, world);
        }
    }

    @Override
    public String getGroupPrefix(String world, String group) {
        PermissionGroup pGroup = PermissionsEx.getPermissionManager().getGroup(group);
        if (group != null) {
            return pGroup.getPrefix(world);
        }
        return null;
    }

    @Override
    public void setGroupPrefix(String world, String group, String prefix) {
        PermissionGroup pGroup = PermissionsEx.getPermissionManager().getGroup(group);
        if (group != null) {
            pGroup.setPrefix(prefix, world);
        }
    }

    @Override
    public String getGroupSuffix(String world, String group) {
        PermissionGroup pGroup = PermissionsEx.getPermissionManager().getGroup(group);
        if (group != null) {
            return pGroup.getSuffix(world);
        }
        return null;
    }

    @Override
    public void setGroupSuffix(String world, String group, String suffix) {
        PermissionGroup pGroup = PermissionsEx.getPermissionManager().getGroup(group);
        if (group != null) {
            pGroup.setSuffix(suffix, world);
        }
    }

    public class PermissionServerListener
    implements Listener {
        Chat_PermissionsEx chat = null;

        public PermissionServerListener(Chat_PermissionsEx chat) {
            this.chat = chat;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.chat.chat == null && (perms = Chat_PermissionsEx.this.plugin.getServer().getPluginManager().getPlugin("PermissionsEx")) != null && perms.isEnabled()) {
                this.chat.chat = (PermissionsEx)perms;
                log.info(String.format("[%s][Chat] %s hooked.", Chat_PermissionsEx.this.plugin.getDescription().getName(), "PermissionsEx_Chat"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.chat.chat != null && event.getPlugin().getDescription().getName().equals("PermissionsEx")) {
                this.chat.chat = null;
                log.info(String.format("[%s][Chat] %s un-hooked.", Chat_PermissionsEx.this.plugin.getDescription().getName(), "PermissionsEx_Chat"));
            }
        }
    }
}

